/***************************************************************************
 *   Copyright (C) 2006 by Meni Livne <livne@kde.org>                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef __PLUGIN_KARPION_H_
#define __PLUGIN_KARPION_H_

#include <qwidget.h>
#include <qcache.h>
#include <qtimer.h>
#include <qthread.h>
#include <kparts/plugin.h>

#include <phish.h>

class KHTMLPart;
class KToolBarLabelAction;
class KAboutApplication;


class KarpionURLData
{
  public:
    KarpionURLData(phish_url_data_t *url_data);
    ~KarpionURLData();
    
    phish_url_data_t *data() const { return m_url_data; };
    
  private:
    phish_url_data_t *m_url_data;
};


class KarpionXMLUpdateThread : public QThread
{
  public:
    KarpionXMLUpdateThread(QObject *caller) : m_caller(caller) {};
    virtual void run();
    phish_result_t result() const { return m_result; };
    
  private:
    QObject *m_caller;
    phish_result_t m_result;
};

class KarpionCheckURLThread : public QThread
{
  public:
    KarpionCheckURLThread(QObject *caller) : m_caller(caller) {};
    virtual void run();
    void setURL(const QString& url) { m_url = url; };
    QString url() const { return m_url; };
    
    phish_result_t result() const { return m_result; };
    phish_url_data_t urlData() const { return m_url_data; };
    
  private:
    QObject *m_caller;
    QString m_url;
    phish_result_t m_result;
    phish_url_data_t m_url_data;
};

class KarpionCheckCountryThread : public QThread
{
  public:
    KarpionCheckCountryThread(QObject *caller) : m_caller(caller) {};
    virtual void run();
    void setURL(const QString& url) { m_url = url; };
    QString url() const { return m_url; };
    
    phish_result_t result() const { return m_result; };
    phish_url_data_t urlData() const { return m_url_data; };
    
  private:
    QObject *m_caller;
    QString m_url;
    phish_result_t m_result;
    phish_url_data_t m_url_data;
};


class KarpionPlugin : public KParts::Plugin
{
  Q_OBJECT
  public:
    KarpionPlugin(QObject* parent = 0, const char *name = 0,
                  const QStringList& = 0);
    virtual ~KarpionPlugin();
    
  protected:
    void customEvent(QCustomEvent *ev);
    
  private slots:
    void delayedSetup();
    
    void checkCurrentURL();
    void updateXML();
    
    void reportPhishing();
    void addToSafeList();
    void configure();
    void about();
    
    void siteInfo();
    
  private:
    void checkURL(const QString& url);
    void checkCountry(const QString& url);
    
    void setRiskLevel(phish_risk_t level);
    void setCheckingRiskLevel();
    void setCountry(const QString& country_code);
    void clearCountry();
    void setCheckingCountry();
    
    void clear();
    
    void readConfig();
    
    phish_url_data_t *m_url_data;
    bool m_safe;
    
    static QCache<KarpionURLData> m_url_cache;
    
    static KConfig *m_config;
    static bool m_config_read;
    static phish_mode_t m_running_mode;
    static bool m_check_country;
    static int m_update_interval;
    
    static QTimer m_update_timer;
    
    KAboutData *m_about_data;
    KAboutApplication *m_aa;
    
    KHTMLPart *m_part;
    
    KarpionXMLUpdateThread xml_thread;
    KarpionCheckURLThread url_thread;
    KarpionCheckCountryThread country_thread;
    
    KToolBarLabelAction *m_country;
    KToolBarLabelAction *m_risk;
    
    KActionMenu *m_menu;
    KAction *m_siteinfo;
    KAction *m_reportphishing;
    KAction *m_addsafelist;
    KAction *m_configure;
    KAction *m_about;
};


#endif // __PLUGIN_KARPION_H_

