/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _KATCATALOG_H
#define _KATCATALOG_H

#include <time.h>
#include <kio/global.h>

#include "kat_export.h"

#include <qtsqlite3.h>
#include <katxattr.h>
#include <config.h>

using namespace KIO;

class KAT_EXPORT KatCatalog
{
public:
    KatCatalog();
    virtual ~KatCatalog();

    int catalogId() const { return m_catalogId; };
    int autoUpdate() const { return m_autoUpdate; };
    QString name() const { return m_name; };
    QString description() const { return m_description; };
    QString path() const { return m_path; };
    QString notes() const { return m_notes; };
    QString author() const { return m_author; };
    int version() const { return m_version; };
    time_t creationDate() const { return m_creationDate; };
    time_t lastUpdateDate() const { return m_lastUpdateDate; };
    int useExclusionList() const { return m_useExclusionList; };
    int thumbnailSize()const { return m_thumbnailSize; };
    int files() const { return m_files; };
    int folders() const { return m_folders; };
    int words() const { return m_words; };
    int fullTexts() const { return m_fullTexts; };
    int thumbnails() const { return m_thumbnails; };
    int metaData() const { return m_metaData; };
    int extractions() const { return m_extractions; };
    KIO::filesize_t fileSize() const { return m_fileSize; };
    bool useExtendedAttr() { return m_usexattr; };

    void setDb( QtSQLite3DB* db ) { m_db = db; };
    void setCatalogId( const int catalogId ) { m_catalogId = catalogId; };
    void setAutoUpdate( const int autoUpdate ) { m_autoUpdate = autoUpdate; };
    void setName( const QString& name ) { m_name = name; };
    void setDescription( const QString& description ) { m_description = description; };
    void setPath( const QString& path )
    {
        m_path = path;
#ifdef HAVE_ATTR_H
        checkxattr();
#endif
    };
    void setNotes( const QString& notes ) { m_notes = notes; };
    void setAuthor( const QString& author ) { m_author = author; };
    void setVersion( int version ) { m_version = version; };
    void setCreationDate( time_t creationDate ) { m_creationDate = creationDate; };
    void setLastUpdateDate( time_t lastUpdateDate ) { m_lastUpdateDate = lastUpdateDate; };
    void setUseExclusionList( int useExclusionList ) { m_useExclusionList = useExclusionList; };
    void setThumbnailSize( int thumbnailSize ) { m_thumbnailSize = thumbnailSize; };
    void setFiles( int files ) { m_files = files; };
    void setFolders( int folders ) { m_folders = folders; };
    void setWords( int words ) { m_words = words; };
    void setFullTexts( int fullTexts ) { m_fullTexts = fullTexts; };
    void setThumbnails( int thumbnails ) { m_thumbnails = thumbnails; };
    void setMetaData( int metaData ) { m_metaData = metaData; };
    void setExtractions( int extractions ) { m_extractions = extractions; };
    void setFileSize( KIO::filesize_t fileSize ) { m_fileSize = fileSize; };

    friend inline bool operator==( const KatCatalog&, const KatCatalog& );
    friend inline bool operator!=( const KatCatalog&, const KatCatalog& );

private:
    QtSQLite3DB* m_db;
    int m_catalogId;
    int m_autoUpdate;
    QString m_name;
    QString m_description;
    QString m_path;
    QString m_notes;
    QString m_author;
    int m_version;
    time_t m_creationDate;
    time_t m_lastUpdateDate;
    int m_useExclusionList;
    int m_thumbnailSize;
    int m_files;
    int m_folders;
    int m_words;
    int m_fullTexts;
    int m_thumbnails;
    int m_metaData;
    int m_extractions;
    KIO::filesize_t m_fileSize;
    bool m_usexattr;
#ifdef HAVE_ATTR_H
    inline void checkxattr() { m_usexattr = KatExtendedAttr::testExtendedAttribute( m_path ); };
#endif
};

#endif // _KATCATALOG_H_
