/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _KATENGINE_H_
#define _KATENGINE_H_

#include <qmap.h>
#include <qbuffer.h>

#include <kathelpers.h>
#include <katcatalog.h>
#include <qtsqlite3.h>
#include <katinformation.h>
#include <katscanfolder.h>
#include <katinfoextractor.h>
#include <kattemptable.h>

class KAT_EXPORT KatEngine
{

public:
    KatEngine();
    ~KatEngine();

    QPtrList<KatCatalog> readCatalogs();
    KatCatalog* readCatalog( int );
    int addCatalog( KatCatalog* );
    int updateCatalog( KatCatalog* );
    KatCatalog* getCatalog( const QString& );
    KatScanFolder* scanFolder( KatCatalog* );
    KatInfoExtractor* extractInfo( KatCatalog* );
    KatTempTable* tempTable( int );

    QMap<int,QString> getFileChildren( int, int );
    KatInformation readFileInformation( int, KatInformation::Type  = KatInformation::All );
    KatInformation readFileInformation( const QString, KatInformation::Type = KatInformation::All );
    blobInfo readFullTextRecord( int );
    QValueList<int> doSearch( const QString&, bool, bool, bool );
    QMap<QString, int> readFileWords( int );
    bool folderHasChildren( int, int );
    int deleteAllCatalogs();
    int deleteCatalog( KatCatalog* );
    int importCatalog( QString& );
    int exportCatalog( KatCatalog*, QString& );

    void pruneCatalog( KatCatalog* );
    void deleteFiles( KatCatalog* , QStringList );

private:
    QtSQLite3DB* m_db;

    int createMainDatabase();
    int createDatabase( const QString& );
    int openMainDatabase();
    QtSQLite3DB* openDatabase( const QString& );
    int closeMainDatabase();
    int closeDatabase( QtSQLite3DB* );
    int openTransaction();
    int commitTransaction();
    int rollbackTransaction();
    int getWordId( QString& );
    void checkTables();
};

#endif // _KATENGINE_H_
