/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _KATINFOEXTRACTOR_H_
#define _KATINFOEXTRACTOR_H_

#include <kio/job.h>
#include <kfileitem.h>
#include <qmap.h>
#include <qintdict.h>

#include <qtsqlite3.h>
#include <katlanguagemanager.h>

#include "kat_export.h"

class KAT_EXPORT KatInfoExtractor : public QObject
{
Q_OBJECT

protected:
    KatInfoExtractor( KatCatalog*, QtSQLite3DB* );

public:
    ~KatInfoExtractor();

    KIO::filesize_t totalSize() const { return m_totalSize; }
    KIO::filesize_t totalFiles() const { return m_totalFiles; }
    KIO::filesize_t totalSubdirs() const { return m_totalSubdirs; }
    KIO::filesize_t totalPreviews() const { return m_totalPreviews; }
    KIO::filesize_t totalMetaData() const { return m_totalMetaData; }
    KIO::filesize_t totalFullTexts() const { return m_totalFullTexts; }
    long totalExtractions() const { return m_totalExtractions; }
    static KatInfoExtractor* extractInfoJob( KatCatalog*, QtSQLite3DB* );
    void updateFiles( const QStringList& );
    void updateFiles( const QMap<QString, long>& );
    void deleteFiles( const QStringList& );
    void deleteFiles( const QMap<QString, long>& );

signals:
    void completed();

public slots:
    void slotAbortExtraction();
    void slotSaveInfo();
    void slotAbortSaveInfo();
    void slotDiscardInfo();

protected:
    void setSync() { m_bAsync = false; }
    void startNextJob( );

protected slots:
    virtual void gotThumbnail( const KFileItem*, const QPixmap& );
    virtual void noThumbnail( const KFileItem* );
    virtual void gotMetaInfo( const KFileItem* );
    virtual void noMetaInfo( const KFileItem* );
    virtual void gotFullText( KIO::Job*, const KFileItem*, const QString& );
    virtual void noFullText( const KFileItem* );
    virtual void resultMetaInfo( KIO::Job* );
    virtual void resultThumbnail( KIO::Job* );
    virtual void resultFullText( KIO::Job* );

private:
    QtSQLite3DB* m_db;
    KatCatalog* m_cat;
    QMap<QString,LanguageProfile>* m_lp;
    bool m_bAsync;
    KIO::filesize_t m_totalSize;
    KIO::filesize_t m_totalFiles;
    KIO::filesize_t m_totalSubdirs;
    KIO::filesize_t m_totalPreviews;
    KIO::filesize_t m_totalMetaData;
    KIO::filesize_t m_totalFullTexts;
    long m_totalExtractions;

    // Let's see if this speeds up things
    QIntDict<QByteArray> m_thumbnail;
    QIntDict<QString> m_metadata;
    QIntDict<QString> m_fulltext;

    QPtrList<KIO::Job> m_subJobs;

    bool m_save;

    // database functions
    int openTransaction();
    int commitTransaction();
    int rollbackTransaction();

    long getWordId( QString& );

    long saveWordRecord( QString& );
    int saveWordfileRecord( long, long, long );
    QMap<QString, long> readFiles( int, QStringList );
    int saveThumbnailRecord( int, QByteArray&, long );
    int saveMetaDataRecord( int, QString& );
    int saveFullTextRecord( int, QByteArray&, long );
    int updateLanguageOfFile( int, QString& );

private:
    class KatInfoExtractor* d;
};

#endif // _KATINFOEXTRACTOR_H_
