/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *   Egon Willighagen <e.willighagen@science.ru.nl>                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include <kdebug.h>

#include "fulltext_deb.h"
#include "kat_export.h"

extern "C"
{
    KAT_EXPORT FulltextExtractor* new_extractor( const QString& path ) {
        return new DEBExtractor( path );
    }
}

DEBExtractor::DEBExtractor( const QString &path )
    :KatExternalExtractor( path, false )

{
    kdDebug() << "DEBExtractor::DEBExtractor( const QString &path ) :************************" << endl;
}

DEBExtractor::~DEBExtractor()
{
    delete proc;
    proc = 0;
    delete kpm;
    kpm = 0;
}

QString DEBExtractor::helper() const
{
    return "dpkg-deb";
}


void DEBExtractor::helperParameter(const QString &_prog)
{
    *proc << _prog;
    *proc << "-f"; // extract a certain field
    *proc << m_path;
    *proc << "Package"; // extract the description
    *proc << "Maintainer"; // extract the description
    *proc << "Description"; // extract the description
}


