/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *   Egon Willighagen : egonw@users.sf.net                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include <kdebug.h>
#include <kmimetype.h>
#include <kfilterdev.h>
#include <kzip.h>
#include <qregexp.h>

#include "fulltext_docbook.h"

DOCBOOKXMLExtractor::DOCBOOKXMLExtractor( const QString& path ) :
    m_bDone( false ),
    m_file( path ),
    m_stream( &m_file )
{
    m_open = m_file.open( IO_ReadOnly );
}

DOCBOOKXMLExtractor::~DOCBOOKXMLExtractor()
{
    m_file.close();
}

void DOCBOOKXMLExtractor::extract( QString& data ) {

    kdDebug() << "DOCBOOKXMLExtractor start" << endl;

    if ( m_bDone ) {
        data = QString::null;
        return;
    }
    m_bDone = true;

    if ( m_open ) {
        QString d = m_stream.read();

        d = d.replace( QRegExp( "<[^>]*>" ), " " ); // strip all XML tags
        d = d.simplifyWhiteSpace();

        QTextOStream stream( &data );
        stream << "<fulltext>";
        stream << d.local8Bit();
        stream << "</fulltext>";
    }

    kdDebug() << "DOCBOOKXMLExtractor end" << endl;
}
