/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *   Egon Willighagen: egonw@users.sf.net                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include <kdebug.h>
#include "kat_export.h"
#include "fulltext_rproject.h"
#include <qfile.h>
#include <qregexp.h>

extern "C"
{
    KAT_EXPORT FulltextExtractor* new_extractor( const QString& path )
    {
        return new RProjectExtractor( path );
    }
}

RProjectExtractor::RProjectExtractor( const QString& path ) :
    m_bDone( false ),
    m_file( path ),
    m_stream( &m_file )
{
    m_open = m_file.open( IO_ReadOnly );
}

RProjectExtractor::~RProjectExtractor()
{
    m_file.close();
}

void RProjectExtractor::extract( QString& data )
{
    kdDebug() << "RProjectExtractor start" << endl;
    if ( m_bDone ) {
        data = QString::null;
        return;
    }
    m_bDone = true;

    QRegExp commentRX = QRegExp("^.*#(.*)");

    if ( m_open ) {
        QString d = "";
        QString myString;
        while (!m_stream.atEnd()) {
            myString = m_stream.readLine();

            if (commentRX.search( myString ) != -1) {
                d = d + commentRX.cap(1) + " ";
            }

            d = d.simplifyWhiteSpace();
        }

        QTextOStream stream( &data );
        stream << "<fulltext>";
        stream << d.local8Bit();
        stream << "</fulltext>";
    }
    kdDebug() << "RProjectExtractor end" << endl;
}
