/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _DLGMAINWINDOW_H_
#define _DLGMAINWINDOW_H_

#include <qvariant.h>
#include <kparts/dockmainwindow.h>
#include <kapplication.h>
#include <kdockwidget.h>
#include <kfiledialog.h>
#include <kiconview.h>
#include <klistview.h>
#include <ktextedit.h>
#include <qheader.h>
#include <qiconview.h>
#include <qlayout.h>
#include <qmainwindow.h>
#include <qpixmap.h>
#include <qsplitter.h>
#include <qwidgetstack.h>
#include <qpopupmenu.h>
#include <qvaluelist.h>
#include <kservice.h>
#include <ktrader.h>
#include <dcopclient.h>
#include <dcopobject.h>
#include <kuniqueapplication.h>

#include "katcatalog.h"
#include "katlistviewitem.h"
#include "katiconviewitem.h"
#include "dlgsearch.h"
#include "katutils.h"
#include "katlistview.h"
#include "katiconview.h"
#include "dlgmainwindowiface.h"

#include <katengine.h>
#include <qguardedptr.h>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QSpacerItem;
class QPopupMenu;
class QSplitter;
class KListView;
class QListViewItem;
class KAction;
class KToggleAction;
class KConfig;
class KatDatabaseManager;
class KIconLoader;
class KSplashScreen;
class KCmdLineArgs;

class DlgMainWindow : public KParts::DockMainWindow, public DlgMainWindowIface
{
    Q_OBJECT

public:
    DlgMainWindow();
    virtual ~DlgMainWindow();


    void insertChildrenFolders( int, int, QListViewItem* );
    void insertChildrenFiles( int, int );
    void showFileProperties( KatInformation );
    void populateViews();
    void populateSearchViews( QValueList<int> );
    void showIcons( KIconLoader*, QIconView* );

    void openFile( KatInformation );
    void createNewCatalog();
    void openCatalog();
    void importCatalog( const KURL &url );

    KatCatalog* cat() const { return m_cat;}
    QPtrList<KatCatalog> catalogs() const { return m_catalogs;}
    KatEngine* katEngine() const { return m_ke;}

    void setCat( KatCatalog* cat ) { m_cat = cat; };
    void deleteCatalogId( int catalogId );
    void addCatalogId( int catalogId );

    void showTipOnStart();

    void activateFileFindMode();
    void activateBrowserMode();
    void activateWizard();
    void callSystray();

public slots:
    void slotFileNew();
    void slotFilePrint();
    void slotFileFind();
    void slotEditUndo();
    void slotEditRedo();
    void slotEditCut();
    void slotEditPaste();
    void slotEditFind();
    void slotEditToolbars();
    void slotEditCopy();
    void slotConfigureKeys();
    void slotDeleteAllCatalogs();
    void slotImportCatalog();
    void slotCatalogProperties();
    void slotDeleteCatalog();
    void slotExportCatalog();

    void slotTipOfTheDay();

    virtual QStringList listOfCatalog();
    virtual void updateCatalog();
    virtual void catalogAdded(int);
    virtual void catalogDeleted(int);

protected slots:
    void slotFolderItemSelected( QListViewItem *);
    void selectFolder( QListViewItem* );
    void selectFile( QListViewItem* );
    void selectFileIcon( QIconViewItem* );
    void selectFileThumbnail( QIconViewItem* );
    void contextFolder( KListView*, QListViewItem*, const QPoint& );
    void contextFile( KListView*, QListViewItem*, const QPoint& );
    void contextFileIcon( QIconViewItem*, const QPoint& );
    void contextFileThumbnail( QIconViewItem*, const QPoint& );
    void contextReqFile( QListViewItem*, const QPoint&, int );
    void contextReqFolder( QListViewItem*, const QPoint&, int );
    void doubleClickedFile( QListViewItem* );
    void doubleClickedFileIcon( QIconViewItem* );
    void doubleClickedFileThumbnail( QIconViewItem* );
    void doubleClickedFolder( QListViewItem* );
    void rightButtonFile( QListViewItem*, const QPoint&, int );
    void rightButtonFolder( QListViewItem*, const QPoint&, int );
    void executeFile( QListViewItem* );
    void executeFolder( QListViewItem* );
    void expandFolder( QListViewItem* );
    void slotViewDetailed();
    void slotViewIcons();
    void slotViewThumbnails();
    void slotShowFullText();
    void slotShowWordsList();
    void slotNewToolBarConfig();
    void slotConfigureKat();
    void slotOpenURL( const KURL& );
    void slotSaveProperties();
    void slotOpenWith( int );
    void slotLaunchWizard();

protected:
    void initActions();
    void initWizard();
    void fileSave();
    void fileNew();
    void importCatalog();
    void disableAction();

    void initView();
    void initStatusBar();
    void openItemSelected( KatListViewItem* item );
    void openItemSelected( KatIconViewItem* item );

    bool queryClose();
    void updateToolbarButton();

    void wizard();
    void executeItem( KatInformation info );
private:
    QPixmap pmCatalogIcon;

    KatEngine* m_ke;
    QPtrList<KatCatalog> m_catalogs;
    KatCatalog* m_cat;

    KTrader::OfferList offers;

    QPixmap pmDiscIcon;
    QPixmap pmFileIconSmall;
    QPixmap pmFolderIconSmall;
    QPixmap pmFileIconLarge;
    QPixmap pmFolderIconLarge;
    QPixmap pmCheckIconSmall;

    KAction* fileNewAction;
    KAction* filePrintAction;
    KAction* fileExitAction;
    KAction* fileCatalogPropertiesAction;
    KAction* fileImportCatalogAction;
    KAction* fileExportCatalogAction;
    KAction* fileDeleteCatalogAction;
    KAction* fileDeleteAllCatalogsAction;

    KAction* editUndoAction;
    KAction* editRedoAction;
    KAction* editCutAction;
    KAction* editCopyAction;
    KAction* editPasteAction;
    KAction* editFindAction;

    //icons from toolbar
    KToggleAction* toolbarSearch;
    KAction* toolbarConfigure;
    KToggleAction* toolbarViewDetailed;
    KToggleAction* toolbarViewIcons;
    KToggleAction* toolbarViewThumbnails;

    KDockWidget* dockMain;
    KDockWidget* dockFolders;
    KDockWidget* dockFiles;
    KDockWidget* dockProperties;

    KDockWidget* dockMainSearch;
    KDockWidget* dockSearch;
    KDockWidget* dockResults;


    KListView* lvFolders;
    KatListView* lvFiles;
    KatIconView* ivFiles;
    KatIconView* ivFilesThumbnails;
    KTextEdit* teProperties;
    DlgSearch* dsSearch;
    KatListView* lvResults;
    KatIconView* ivResults;
    KatIconView* ivResultsThumbnails;

    QPopupMenu* foldersMenu;

    QPopupMenu* resultsMenu;
    QPopupMenu* resultsIconsMenu;
    QPopupMenu* resultsThumbnailsMenu;

    QPopupMenu* filesMenu;
    QPopupMenu* filesIconsMenu;
    QPopupMenu* filesThumbnailsMenu;

    KConfig* m_config;
};

class KatApplication : public KUniqueApplication
{
    Q_OBJECT

 public:
    KatApplication();
    ~KatApplication();

    int newInstance();
    void importFile( KCmdLineArgs *args );

private:
    DlgMainWindow *m_mainWindow;
};

#endif //_DLGMAINWINDOW_H_
