/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include "dlgsearch.h"

#include <kapplication.h>
#include <klocale.h>
#include <qvariant.h>
#include <qsplitter.h>
#include <qtabwidget.h>
#include <qlabel.h>
#include <qbuttongroup.h>
#include <qvbuttongroup.h>
#include <qcheckbox.h>
#include <kpushbutton.h>
#include <klineedit.h>
#include <kicondialog.h>
#include <ktextedit.h>

#include "katengine.h"

#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qiconset.h>
#include <qvaluelist.h>

#include "dlgmainwindow.h"


DlgSearch::DlgSearch( QWidget* parent, const char* name, WFlags fl )
    : QWidget( parent, name, fl )
{
    setCaption( i18n( "Kat" ) );
    QGridLayout *mainGrid = new QGridLayout( this, 2, 1, KDialog::marginHint(), KDialog::spacingHint() );

    // Button icon (22 pixels)
    QIconSet isSearchButton = createToolbarIconSet( "find" );

    if ( !name )
        setName( "Search" );

    QTabWidget *SearchSetup = new QTabWidget( this, "SearchSetup" );
    QWidget* tab = new QWidget( SearchSetup, "tab" );

    QGridLayout *grid1 = new QGridLayout( tab, 2, 2, KDialog::marginHint(), KDialog::spacingHint() );


    QHBoxLayout *vlayout = new QHBoxLayout;
    //QGridLayout *vlayout = new QGridLayout( tab, 8, 1);

    grid1->addMultiCellLayout( vlayout,0,0,0,0 );

    tlSearch = new QLabel( tab, "tlSearch" );
    tlSearch->setText( i18n( "Search:" ) );
    vlayout->addWidget( tlSearch );

    leSearchText = new KLineEdit( tab, "leSearchText" );
    vlayout->addWidget( leSearchText );

    grid1->addMultiCellLayout( vlayout,0,0,0,0 );



    QVButtonGroup *bgSearchParameters = new QVButtonGroup( tab, "bgSearchParameters" );
    bgSearchParameters->setTitle( i18n( "Parameters" ) );

    cbFilenames = new QCheckBox( i18n( "Search in file names" ), bgSearchParameters, "cbFilenames" );
    cbFilenames->setChecked( true );

    cbDescriptions = new QCheckBox( i18n( "Search in metadata" ), bgSearchParameters, "cbDescriptions" );
    cbDescriptions->setChecked( true );

    cbFullTexts = new QCheckBox( i18n( "Search in fulltexts" ), bgSearchParameters, "cbFullTexts" );
    cbFullTexts->setChecked( true );
    grid1->addMultiCellWidget( bgSearchParameters, 1 , 1 , 0,0 );


    //QVBoxLayout *tmplayout2 = new QVBoxLayout;

    QGridLayout *tmplayout2 = new QGridLayout( tab, 8, 1);
    ibStartSimpleSearch = new KPushButton( i18n( "Search" ), tab, "ibStartSimpleSearch" );
    tmplayout2->addWidget( ibStartSimpleSearch,0,0);
    ibStartSimpleSearch->setIconSet( isSearchButton );
    ibStartSimpleSearch->setEnabled( true );

#if 0
    pbLimitSimpleSearch = new KPushButton( i18n( "Limit Search" ), tab, "pbLimitSimpleSearch" );
    pbLimitSimpleSearch->setEnabled( false );
    tmplayout2->addWidget( pbLimitSimpleSearch );


    pbConfigureSimple = new KPushButton( i18n( "Configure..." ), tab, "pbConfigureSimple" );
    pbConfigureSimple->setEnabled( false );
    tmplayout2->addWidget( pbConfigureSimple );
#endif



    SearchSetup->insertTab( tab, i18n( "Search" ));

    grid1->addMultiCellLayout( tmplayout2,0,1,1,1 );

    //second tab
#if 0
    QWidget* tab_2 = new QWidget( SearchSetup, "tab_2" );
    tab_2->setEnabled( false );

    QGridLayout *grid2 = new QGridLayout( tab_2, 5, 4, KDialog::marginHint(), KDialog::spacingHint() );


    teCriteria = new KTextEdit( tab_2, "teCriteria" );
    grid2->addMultiCellWidget( teCriteria,0,3,0,1 );


    pbInsert = new KPushButton( i18n( "Insert" ), tab_2, "pbInsert" );
    grid2->addWidget( pbInsert, 0, 2 );

    pbModify = new KPushButton( i18n( "Modify" ), tab_2, "pbModify" );
    grid2->addWidget( pbModify, 1, 2 );

    pbValidate = new KPushButton( i18n( "Validate" ), tab_2, "pbValidate" );
    grid2->addWidget( pbValidate, 2, 2 );

    pbOptions = new KPushButton( i18n( "Options" ), tab_2, "pbOptions" );
    grid2->addWidget( pbOptions, 4, 2 );

    ibStartAdvancedSearch = new KPushButton( i18n( "Search" ), tab_2, "ibStartAdvancedSearch" );
    ibStartAdvancedSearch->setIconSet( isSearchButton );
    ibStartAdvancedSearch->setEnabled( true );
    grid2->addWidget( ibStartAdvancedSearch, 0, 3 );


    pbLimitAdvancedSearch = new KPushButton( i18n( "Limit Search" ), tab_2, "pbLimitAdvancedSearch" );
    grid2->addWidget( pbLimitAdvancedSearch, 1, 3 );

    pbConfigureAdvanced = new KPushButton( i18n( "Configure..." ), tab_2, "pbConfigureAdvanced" );
    grid2->addWidget( pbConfigureAdvanced, 2, 3 );



    QHBoxLayout *vlayout2 = new QHBoxLayout;
    grid2->addMultiCellLayout( vlayout2,4,4,0,1 );



    pbAnd = new KPushButton( i18n( "AND" ), tab_2, "pbAnd" );
    vlayout2->addWidget( pbAnd );

    pbOr = new KPushButton( i18n( "OR" ), tab_2, "pbOr" );
    vlayout2->addWidget( pbOr );

    pbXor = new KPushButton( i18n( "XOR" ), tab_2, "pbXor" );
    vlayout2->addWidget( pbXor );

    pbNot = new KPushButton( i18n( "NOT" ), tab_2, "pbNot" );
    vlayout2->addWidget( pbNot );

    pbParenthesisOpen = new KPushButton( i18n( "(" ), tab_2, "pbParenthesisOpen" );
    vlayout2->addWidget( pbParenthesisOpen );

    pbParenthesisClose = new KPushButton( i18n( ")" ), tab_2, "pbParenthesisClose" );
    vlayout2->addWidget( pbParenthesisClose );



    SearchSetup->insertTab( tab_2,i18n( "Advanced Search" ) );
#endif

    resize( QSize(802, 301).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );

    // signals and slots connections
    connect( ibStartSimpleSearch, SIGNAL( clicked() ),
             this, SLOT( simpleStartSearch() ) );
#if 0
    connect( pbLimitSimpleSearch, SIGNAL( clicked() ),
             this, SLOT( simpleLimitSearch() ) );
    connect( pbConfigureSimple, SIGNAL( clicked() ),
             this, SLOT( simpleConfigure() ) );
    connect( ibStartAdvancedSearch, SIGNAL( clicked() ),
             this, SLOT( advancedStartSearch() ) );
    connect( pbLimitAdvancedSearch, SIGNAL( clicked() ),
             this, SLOT( advancedLimitSearch() ) );
    connect( pbConfigureAdvanced, SIGNAL( clicked() ),
             this, SLOT( advancedConfigure() ) );
    connect( pbNot, SIGNAL( clicked() ),
             this, SLOT( criteriaNot() ) );
    connect( pbXor, SIGNAL( clicked() ),
             this, SLOT( criteriaXor() ) );
    connect( pbAnd, SIGNAL( clicked() ),
             this, SLOT( criteriaAnd() ) );
    connect( pbInsert, SIGNAL( clicked() ),
             this, SLOT( criteriaInsert() ) );
    connect( pbModify, SIGNAL( clicked() ),
             this, SLOT( criteriaModify() ) );
    connect( pbOr, SIGNAL( clicked() ),
             this, SLOT( criteriaOr() ) );
    connect( pbParenthesisOpen, SIGNAL( clicked() ),
             this, SLOT( criteriaParenthesisOpen() ) );
    connect( pbParenthesisClose, SIGNAL( clicked() ),
             this, SLOT( criteriaParenthesisClose() ) );
    connect( pbValidate, SIGNAL( clicked() ),
             this, SLOT( criteriaValidate() ) );
    connect( pbOptions, SIGNAL( clicked() ),
             this, SLOT( criteriaOptions() ) );
#endif
    connect( leSearchText, SIGNAL( returnPressed () ),
             this, SLOT( simpleStartSearch() ) );
    connect( leSearchText, SIGNAL( textChanged ( const QString & ) ),
             this, SLOT( slotTextChanged(const QString & ) ) );
    slotTextChanged(  leSearchText->text() );
    mainGrid->addWidget( SearchSetup, 0, 0 );
}

DlgSearch::~DlgSearch()
{
}

void DlgSearch::slotTextChanged(const QString &_text )
{
    ibStartSimpleSearch->setEnabled( !_text.isEmpty() );
}

void DlgSearch::simpleStartSearch()
{
    QValueList<int> results;
    bool filenames;
    bool descriptions;
    bool fulltexts;

    filenames = cbFilenames->isChecked();
    descriptions = cbDescriptions->isChecked();
    fulltexts = cbFullTexts->isChecked();
    DlgMainWindow* mf = (DlgMainWindow*)kapp->mainWidget();

    results = mf->katEngine()->doSearch( leSearchText->text(), filenames, descriptions, fulltexts );

    mf->populateSearchViews( results );
}

void DlgSearch::simpleLimitSearch()
{
}

void DlgSearch::simpleConfigure()
{
}

void DlgSearch::advancedStartSearch()
{
}

void DlgSearch::criteriaAnd()
{
}

void DlgSearch::criteriaOr()
{
}

void DlgSearch::criteriaXor()
{
}

void DlgSearch::criteriaNot()
{
}

void DlgSearch::criteriaParenthesisOpen()
{
}

void DlgSearch::criteriaParenthesisClose()
{
}

void DlgSearch::criteriaInsert()
{
}

void DlgSearch::criteriaModify()
{
}

void DlgSearch::criteriaValidate()
{
}

void DlgSearch::advancedLimitSearch()
{
}

void DlgSearch::advancedConfigure()
{
}


void DlgSearch::criteriaOptions()
{
}

#include "dlgsearch.moc"
