/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include <kdialogbase.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <qvariant.h>
#include <qsplitter.h>
#include <qtextedit.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <kfiledialog.h>
#include <kstdguiitem.h>
#include <qvbox.h>
#include <kdebug.h>

#include "dlgshowfulltext.h"
#include "dlgmainwindow.h"

DlgShowFullText::DlgShowFullText( DlgMainWindow* mf, int fileId, const char* name, bool modal, WFlags fl )
   : KDialogBase( mf, name, modal, i18n( "Fulltext" ), KDialogBase::User1|KDialogBase::Cancel),
     m_mf( mf )
{
    QVBox *page = makeVBoxMainWidget();

    teFullText = new QTextEdit( page, "teFullText" );

    setButtonGuiItem( KDialogBase::User1, KStdGuiItem::saveAs() );

    resize( QSize(532, 297).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );

    // signals and slots connections
    connect( this, SIGNAL( user1Clicked() ), this, SLOT( slotSave() ) );
    init(fileId);
}

DlgShowFullText::~DlgShowFullText()
{
}

void DlgShowFullText::init( int fileId)
{
    blobInfo bi = m_mf->katEngine()->readFullTextRecord( fileId );
    QByteArray xba = bi.blobData;
    xba = qUncompress( xba );
    QString fullText = QString::fromUtf8( xba.data() );
/*
    kdDebug() << "KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK" << endl;
    kdDebug() << fullText << endl;
    kdDebug() << "KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK" << endl;
*/

    teFullText->setText( fullText );
}

void DlgShowFullText::slotSave()
{
    QString fn = KFileDialog::getSaveFileName( QString::null, "*.txt|"+i18n( "Text Files (*.txt)" ), this ,
                                               i18n( "Specify Location & Filename for Text File" ) );
    if ( !fn.isEmpty() )
    {
        // save the text file
        bool m_open;
        QFile m_file( fn );
        QTextStream m_stream( &m_file );

        m_open = m_file.open( IO_WriteOnly );
        if ( m_open )
        {
            m_stream << teFullText->text();
            m_file.close();

            KMessageBox::information( this, i18n( "The file has been successfully saved" ) );
        }
        else
        {
            KMessageBox::error( this, i18n( "The file cannot be created in the specified location" ) );
        }

    }
}

#include "dlgshowfulltext.moc"
