/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include "katlistviewitem.h"

#include <qlistview.h>
#include <kdebug.h>
#include <katengine.h>

int KatListViewItem::compare( QListViewItem* other, int column, bool ascending ) const
{
    QString key1, key2 = QString::null;
    long size1, size2 = 0L;

    if ( column == 0 )
    {
        if ( info.fileType == "inode/directory" )
            key1 = "0" + info.fileName;
        else
            key1 = "1" + info.fileName;

        if ( static_cast<KatListViewItem*>(other)->info.fileType == "inode/directory" )
            key2 = "0" + static_cast<KatListViewItem*>(other)->info.fileName;
        else
            key2 = "1" + static_cast<KatListViewItem*>(other)->info.fileName;

        if ( key1 < key2 )
            return -1;
        else if ( key1 > key2 )
            return 1;
        else
            return 0;

    }
    else if ( column == 3 )
    {
        if ( info.fileType == "inode/directory" )
            size1 = -1L;
        else
            size1 = info.fileSize;

        if ( static_cast<KatListViewItem*>(other)->info.fileType == "inode/directory" )
            size2= -1L;
        else
            size2 = static_cast<KatListViewItem*>(other)->info.fileSize;

        if ( size1 < size2 )
            return -1;
        else if ( size1 > size2 )
            return 1;
        else
            return 0;

    }
    else
    {
        return QListViewItem::compare( other, column, ascending );
    }
}
