/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _LANGUAGEMANAGEMENT_H_
#define _LANGUAGEMANAGEMENT_H_

#include <kdialogbase.h>

class QPushButton;
class QTabWidget;
class QWidget;
class QListView;
class QListViewItem;
class QListBox;
class QListBoxItem;
class QLabel;
class KEditListBox;

class languageManagement : public QWidget
{
Q_OBJECT

public:
    languageManagement(  QWidget* parent = 0, const char* name = 0 );
    ~languageManagement();

protected:
    void updateGUI( bool b );

protected slots:
    void slotAddLanguage();
    void slotDeleteLanguage();
    void slotCreateProfile();
    void slotDeleteProfile();
    void slotAddExclusion( const QString& );
    void slotDeleteExclusion( const QString& );
    void slotSelectLanguage( QListBoxItem* );

private:
    QStringList languages;
    QPushButton* bDeleteLanguage;
    QTabWidget* tabWidget;
    QWidget* Widget2;
    QPushButton* bDeleteLanguageProfile;
    QListView* lvLanguageProfile;
    QWidget* Widget3;
    QListBox* lbLanguages;
    QStringList m_languageFiles;
    QStringList m_exclusionFiles;
    KEditListBox* lbExclusions;
};

#endif // _DLGLANGUAGEMANAGEMENT_H_
