/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _KATSLAVE_H_
#define _KATSLAVE_H_

#include <qstring.h>
#include <qcstring.h>
#include <kurl.h>
#include <kio/global.h>
#include <kio/slavebase.h>

class QCString;
class KatEngine;

class kio_katslaveProtocol : public KIO::SlaveBase
{
public:
    kio_katslaveProtocol( const QCString& pool_socket, const QCString& app_socket );
    virtual ~kio_katslaveProtocol();
    virtual void mimetype( const KURL& url );
    virtual void get( const KURL& url );
    virtual void listDir( const KURL & url );
    virtual void stat( const KURL & url );
    
protected:
    QValueList<int> parseSearch( const QString& _url, QString& word );

private:
    KatEngine* m_ke;
};

#endif // _KATSLAVE_H_
