/***************************************************************************
 *   Copyright (C) 2005 by Egon Willighagen                                *
 *   Egon Willighagen: egonw@users.sf.net                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/


#include <config.h>
#include "kfile_rproject.h"

#include <kgenericfactory.h>
//#include <kio/global.h>

#include <qfile.h>
#include <qregexp.h>
//#include <qdir.h>

typedef KGenericFactory<rprojectPlugin> rprojectFactory;

K_EXPORT_COMPONENT_FACTORY(kfile_rproject, rprojectFactory( "kfile_rproject" ))

rprojectPlugin::rprojectPlugin(QObject *parent, const char *name,
                       const QStringList &args)
    : KFilePlugin(parent, name, args)
{
    KFileMimeTypeInfo* info = addMimeTypeInfo( "application/x-rproject" );

    KFileMimeTypeInfo::GroupInfo* group = 0L;
    group = addGroupInfo(info, "Info", i18n("Information"));

    KFileMimeTypeInfo::ItemInfo* item;

    item = addItemInfo(group, "UsedLibs", i18n("Used Libraries"), QVariant::String);

}

bool rprojectPlugin::readInfo( KFileMetaInfo& info, uint /*what*/)
{
    QFile file( info.path().latin1() );
    file.open( IO_ReadOnly );
    QTextStream stream( &file );

    QString libs = "";
    QRegExp loadlibRX1 = QRegExp("library\\(\\s*([^\\)]*)\\s*\\)");
    QRegExp loadlibRX2 = QRegExp("library\\(\\s*([^,]*)\\s*,");

    QString myString;
    while (!stream.atEnd()) {
        myString = stream.readLine();

        if (loadlibRX2.search( myString ) != -1) {
            libs = libs + " " + loadlibRX2.cap(1);
        } else if (loadlibRX1.search( myString ) != -1) {
            libs = libs + " " + loadlibRX1.cap(1);
        }
    }

    KFileMetaInfoGroup group = appendGroup(info, "Info");
    appendItem(group, "UsedLibs", libs);
    file.close();

    return true;
}

#include "kfile_rproject.moc"

