/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *   Fred Schaettgen : kde.sch@ttgen.net                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include <qfile.h>
#include <qbuffer.h>
#include <kurl.h>
#include <kfileitem.h>
#include <ktrader.h>
#include <kapplication.h>
#include <kglobal.h>
#include <kmimetype.h>
#include <klibloader.h>
#include <kdebug.h>
#include <kservice.h>
#include <kservicetype.h>
#include <kuserprofile.h>
#include <qregexp.h>
#include "kat_export.h"
#include "fulltext.h"
#include <unistd.h>

// Recognized metadata entries:
// mimeType     - the mime type of the file, used for the overlay icon if any
// plugin       - the name of the plugin library to be used for fulltext creation.
//                Provided by the application to save an addition KTrader
//                query here.

using namespace KIO;

extern "C"
{
    KAT_EXPORT int kdemain( int argc, char** argv );
}

int kdemain( int argc, char** argv )
{
    nice( 5 );
    // creating KApplication in a slave in not a very good idea,
    // as dispatchLoop() doesn't allow it to process its messages,
    // so it for example wouldn't reply to ksmserver - on the other
    // hand, this slave uses QPixmaps for some reason, and they
    // need QApplication
    // and HTML previews need even KApplication :(
    putenv( strdup( "SESSION_MANAGER=" ) );
    KApplication::disableAutoDcopRegistration();

    KApplication app( argc, argv, "kio_fulltext", false, true );

    if ( argc != 4 )
    {
        kdError() << "Usage: kio_fulltext protocol domain-socket1 domain-socket2" << endl;
        exit( -1 );
    }

    FulltextProtocol slave( argv[ 2 ], argv[ 3 ] );
    slave.dispatchLoop();

    return 0;
}

FulltextProtocol::FulltextProtocol( const QCString& pool, const QCString& app )
    : SlaveBase( "fulltext", pool, app )
{
}

FulltextProtocol::~FulltextProtocol()
{
}

void FulltextProtocol::get( const KURL& outerURL )
{
    KURL url( outerURL.path() );
    /*KTrader::OfferList plugins = KTrader::self()->query("ThumbCreator");
    QMap<QString, KService::Ptr> mimeMap;

    for (KTrader::OfferList::ConstIterator it = plugins.begin(); it != plugins.end(); ++it)
        if (!d->enabledPlugins || d->enabledPlugins->contains((*it)->desktopEntryName()))
    {
        QStringList mimeTypes = (*it)->property("MimeTypes").toStringList();
        for (QStringList::ConstIterator mt = mimeTypes.begin(); mt != mimeTypes.end(); ++mt)
            mimeMap.insert(*mt, *it);
    }*/

    // Determine the mimetype of the source file
    // in case the mimetype wasn't passed in the kio metadata
    QString mimetype = metaData( "mimeType" );
    if ( mimetype.isEmpty() )
    {
        mimetype = KFileItem( KFileItem::Unknown, KFileItem::Unknown, url, true ).mimetype();
    }

    //ThumbCreator::Flags flags = ThumbCreator::None;
    // Find a suitable plugin for the given mime type
    kdDebug() << "using fulltext extractor for the fulltext" << endl;
    QString plugin = metaData( "plugin" );
    if ( plugin.isEmpty() ) {
        KTrader::OfferList plugins = KTrader::self()->query( "FulltextExtractor" );
        // TODO: Cache mimetype->plugin mapping
        // We've got to find an appropriate plugin for the current mime type
        QMap<QString, QString> mimeMap;
        KTrader::OfferList::ConstIterator end( plugins.end() );
        for ( KTrader::OfferList::ConstIterator it = plugins.begin(); it != end; ++it ) {
            kdDebug() << "plugin: " << (*it)->property( "Name" ).toString() << endl;
            kdDebug() << "mimetypes: " << (*it)->property( "MimeTypes" ).toStringList().join( " " ) << endl;
            QStringList mimeTypes = (*it)->property( "MimeTypes" ).toStringList();
            QStringList::ConstIterator endList( mimeTypes.end() );
            for ( QStringList::ConstIterator mt = mimeTypes.begin(); mt != endList; ++mt ) {
                kdDebug() << *mt << "->" << (*it)->library() << endl;
                mimeMap.insert( *mt, (*it)->library() );
            }
        }

        kdDebug() << "searching for mimetype >" << mimetype << "<" << endl;
        kdDebug() << "searching for mimetype >" << QString( mimetype ).replace(QRegExp( "/.*" ), "/*" ) << "<" << endl;
        QMap<QString, QString>::iterator iPlug;
        if ( mimeMap.end() != ( iPlug = mimeMap.find( mimetype ) ) ) {
            plugin = *iPlug;
        }
        else if ( mimeMap.end() != ( iPlug = mimeMap.find( QString( mimetype ).replace( QRegExp( "/.*" ), "/*" ) ) ) )
        {
            plugin = *iPlug;
        }
        else {
            error( KIO::ERR_INTERNAL, QString( "No plugin available for url=%1 mimetype=%2." ).arg( url.url() ).arg( mimetype ) );
            return;
        }
        kdDebug() << "using plugin " << plugin << endl;
    }

    // Factory function to create an extractor
    newFulltextExtractor extractorCreate = m_extractorCreators[ plugin ];

    if ( !extractorCreate ) {
        // Don't use KLibFactory here, this is not a QObject and
        // neither is FulltextExtractor
        KLibrary* library = KLibLoader::self()->library( QFile::encodeName( plugin ) );
        if ( library )
        {
            extractorCreate = (newFulltextExtractor)library->symbol( "new_extractor" );
        }
        if ( !extractorCreate )
        {
            error( KIO::ERR_INTERNAL, "Cannot load FulltextExtractor " + plugin );
            return;
        }
        m_extractorCreators.insert( plugin, extractorCreate );
    }

    // Size of returend blocks, rather arbitrary
    QString fulltextData;

    FulltextExtractor* extractor = extractorCreate( url.path() );
    while ( extractor->extract( fulltextData ), fulltextData.length() > 0 )
    {
        data( fulltextData.utf8() );
    }
    delete extractor;

    finished();
}

void FulltextProtocol::mimeType( const KURL& )
{
    mimeType( "text/xml" );
}

