/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _KATSCANFOLDER_H_
#define _KATSCANFOLDER_H_

#include <kio/job.h>
#include <kfileitem.h>

#include <qtsqlite3.h>
#include <katcatalog.h>

class KAT_EXPORT KatScanFolder : public QObject
{
Q_OBJECT

protected:
    KatScanFolder( KatCatalog*, QtSQLite3DB* );

public:
    ~KatScanFolder() {};

    KIO::filesize_t totalSize() const { return m_totalSize; }
    KIO::filesize_t totalFiles() const { return m_totalFiles; }
    KIO::filesize_t totalSubdirs() const { return m_totalSubdirs; }
    static KatScanFolder* scanFolderJob( KatCatalog*, QtSQLite3DB* );

    void updateFiles( const QStringList& );
    void addFiles( const QStringList& );
    void deleteFiles( const QStringList& );
    void moveFiles ( const QMap<QString, QString>& );

protected:
    void setSync() { m_bAsync = false; }

private:
    QtSQLite3DB* m_db;
    KatCatalog* m_cat;

    bool m_bAsync;
    KIO::filesize_t m_totalSize;
    KIO::filesize_t m_totalFiles;
    KIO::filesize_t m_totalSubdirs;

    // database functions
    int openTransaction();
    int commitTransaction();
    void rename( const QString& , const QString& );
    void handleMove( const QString& , const QString& );
    inline void setAttributes( const QString&, int, time_t );

private:
    class KatScanFolder* d;
};

#endif // _KATSCANFOLDER_H_
