/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _DLGNEWCATALOG_H_
#define _DLGNEWCATALOG_H_

#include <qvariant.h>
#include <kdialogbase.h>
#include <qstring.h>

#include "katcatalog.h"
#include "kat_export.h"

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QSpacerItem;
class QTabWidget;
class QWidget;
class QLineEdit;
class QLabel;
class QTextEdit;
class QPushButton;
class KActionSelector;
class QCheckBox;
class QSlider;
class KURLRequester;

class KAT_EXPORT DlgNewCatalog : public KDialogBase
{
    Q_OBJECT

public:
    DlgNewCatalog( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~DlgNewCatalog();
    KatCatalog *newCatalog();

public slots:
    virtual void slotChangedCatalogname();
    virtual void slotOk();
    virtual void slotUseExclusionList( int );
    virtual void slotManageExclusionList();
    virtual void slotThumbnailSizeValueChanged( int );
    virtual void slotChangedBaseFolder();

private:

    QTabWidget* tabWidget;
    KURLRequester* leBaseFolder;
    QLabel* tlCatalogName;
    QLabel* tlBaseFolder;
    QLabel* tlDescription;
    QLabel* tlAuthor;
    QLabel* tlNotes;
    QLabel* tlAutoUpdate;
    QLineEdit* leAuthor;
    QTextEdit* teDescription;
    QTextEdit* teNotes;
    QLineEdit* leCatalogName;
    QCheckBox* cbAutoUpdate;
    KActionSelector* asMimeTypes;
    KActionSelector* asDescriptionPlugins;
    QWidget* TabPage;
    KActionSelector* asFullTextPlugins;
    QCheckBox* cbUseExclusionList;
    QPushButton* bManageExclusionList;
    KActionSelector* asThumbnailPlugins;
    QLabel* tlThumbnailSize;
    QSlider* slThumbnailSize;
    QLabel* tlSize;
};

#endif // _DLGNEWCATALOG_H_
