/***************************************************************************
 *   Copyright (C) 2006 by Stefano Salvador                                *
 *   stefano.salvador@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qdom.h>

#include <kurl.h>
#include <kfileitem.h>

using namespace KIO;

class KatalogIO;
class KatalogFS;
class KatalogInfo;

class Katalog_ExportXML
{
  public:
    Katalog_ExportXML();

    ~Katalog_ExportXML();

    /** Export document from the main DB */
    int exportData(KURL & source, KURL & destination);

    /** Enumerator for error codes */
    enum Errors { SUCCESS = 0, EXPORT_MIME_NOT_SUPPORTED = 1, WRITE_ERROR = 2};

    enum Type { E_LINK = 1, E_DIR = 2, E_FILE = 4 };

  private:
    QDomElement m_rootElement;
    QDomDocument m_document;
    KatalogIO * m_kio;
    KatalogFS * m_kfs;
    KatalogInfo * m_kinfo;
    int exportNode(QStringList path, QDomElement &element);
    void exportMetaInfo(QStringList path, QDomElement &element);
};
