/***************************************************************************
 *   Copyright (C) 2004 by Stefano Salvador                                *
 *   stefano.salvador@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "katalogdcop.h"

#include <kdebug.h>
#include <kapplication.h>

#include <dcopclient.h>

katalogdcop::katalogdcop() : QObject(), DCOPObject("katalogdcopInterface")
{
  k = new Katalog();
  runningJobs = 0;
}

katalogdcop::~katalogdcop()
{}

KatalogUDSEntryList katalogdcop::getNodeContent(QString path)
{
  if(!checkDB()){
    KatalogUDSEntryList list;
    list.clear();
    return list;
  }
  QStringList list = QStringList::split("/", path, false);
  return k->getNodeContent(list);
}

/** Adds the items found in mount to the catalog, creating it if not exist */
void katalogdcop::addItems(KURL mount,
                          QString catalog,
                          bool exploreArchives,
                          bool getMetaInfo)
{
  if(!checkDB())
    return;

  k->addItems(mount, catalog, exploreArchives, getMetaInfo);
  ++runningJobs;
  connect( k, SIGNAL( totItems(int) ), SLOT(slotTotItems(int)));
  connect( k, SIGNAL( finished(QString) ), SLOT(slotFinished(QString)));
  connect( k, SIGNAL( currentFolder(QString) ), SLOT( slotCurrentFolder(QString) ) );
  connect( k, SIGNAL( newItem() ), SLOT( slotNewItem() ) );
}

/** Get the given entry */
KatalogUDSEntry katalogdcop::findEntry(QString path)
{
  if(!checkDB()){
    KatalogUDSEntry entry;
    entry.clear();
    return entry;
  }
  QStringList list = QStringList::split("/", path, false);
  return k->findEntry(list);
}

/** Rename a node */
bool katalogdcop::rename(QString path, QString newName)
{
  if(!checkDB())
    return false;
  QStringList list = QStringList::split("/", path, false); 
  bool e = k->rename(list, newName);
  return e;
}

/** Delete a node */
void katalogdcop::del(QString path)
{
  if(!checkDB())
    return;
  QStringList list = QStringList::split("/", path, false);
  k->del(list);
}

/** Returns the original URL of the stored file */
KURL katalogdcop::sourceURL(QString path)
{
  if(!checkDB())
    return "";
  QStringList list = QStringList::split("/", path, false);
  return k->sourceURL(list);
}

KatalogInfoList katalogdcop::readInfo(QString path)
{
  if(!checkDB())
    return KatalogInfoList();
  QStringList list = QStringList::split("/", path, false);
  return k->readInfo(list);
}

void katalogdcop::slotFinished(QString url){
  --runningJobs;
  QByteArray params;
  QDataStream stream(params, IO_WriteOnly);
  stream << url;
  emitDCOPSignal("finished(QString)", params);
}

void katalogdcop::slotCurrentFolder(QString url){
  QByteArray params;
  QDataStream stream(params, IO_WriteOnly);
  stream << url;
  emitDCOPSignal("currentFolder(QString)", params);
}

void katalogdcop::slotNewItem(){
  QByteArray params;
  emitDCOPSignal("newItem()", params);
}

void katalogdcop::stopJobs()
{
  k->stopJobs();
}

void katalogdcop::slotTotItems(int i)
{
  QByteArray params;
  // TODO params << QVariant(i);
  emitDCOPSignal("totItems(int)", params);
}

bool katalogdcop::exit()
{
  if(runningJobs == 0)
  {
    kapp->quit();
    return true;
  }
  else
    return false;
}

bool katalogdcop::checkDB(){
  if(!k->isActive()){
    delete k;
    k = new Katalog();
    return k->isActive();
  }
  return true;;
}

#include "katalogdcop.moc"
