/***************************************************************************
 *   Copyright (C) 2004 by Stefano Salvador                                *
 *   stefano.salvador@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _katalogdcop_H
#define _katalogdcop_H

#include <katalogdcopinterface.h>

#include <kataloguds.h>
#include <katalog.h>

#include <qstringlist.h>
#include <qstring.h>
#include <qmap.h>

#include <dcopobject.h>
#include <kurl.h>
#include <kio/job.h>
#include <kfilemetainfo.h>

class Katalog;

class katalogdcop : public QObject, virtual public katalogdcopInterface
{
Q_OBJECT

private:
  Katalog *k;

  int runningJobs;

  bool checkDB();

public:
  katalogdcop();
  ~katalogdcop();

k_dcop:
  /** Get the list of contents in a node */
  virtual KatalogUDSEntryList getNodeContent(QString fullPath);

  /** Adds the items found in mount to the catalog, creating it if not exist */
  virtual void addItems(KURL mount,
               QString catalog,
               bool exploreArchives=false,
               bool getMetaInfo=false);

  /** Get the given entry */
  virtual KatalogUDSEntry findEntry(QString fullPath);

  /** Rename a node */
  virtual bool rename(QString path, QString newName);

  /** Delete a node */
  virtual void del(QString path);

  /** Returns the original URL of the stored file */
  virtual KURL sourceURL(QString path);

  /** Returns the Meta Info of the specified file */
  virtual KatalogInfoList readInfo(QString path);

  /** */
  virtual void stopJobs();

  /** Exits */
  virtual bool exit();

k_dcop_signals:
  /** Emitted when the creation of the catalog or the import/export is finished */
  void finished(QString);

  /** Notify the folder currently explored */
  void currentFolder(QString);

  /** Progress in exploration */
  void newItem();

  /**  */
  void totItems(int);

private slots:
  void slotFinished(QString);
  void slotCurrentFolder(QString);
  void slotTotItems(int);
  void slotNewItem();
};
#endif
