/***************************************************************************
 *   Copyright (C) 2004 by Stefano Salvador                                *
 *   stefano.salvador@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _katalogdcopinterface_H
#define _katalogdcopinterface_H

#include <kataloguds.h>
#include <katalog.h>

#include <qstringlist.h>
#include <qstring.h>
#include <qmap.h>

#include <dcopobject.h>
#include <kurl.h>
#include <kio/job.h>
#include <kfilemetainfo.h>

class Katalog;

class katalogdcopInterface : virtual public DCOPObject
{
K_DCOP

k_dcop:
  /** Get the list of contents in a node */
  virtual KatalogUDSEntryList getNodeContent(QString fullPath) = 0;

  /** Adds the items found in mount to the catalog, creating it if not exist */
  virtual void addItems(KURL mount,
               QString catalog,
               bool exploreArchives=false,
               bool getMetaInfo=false) = 0;

  /** Get the given entry */
  virtual KatalogUDSEntry findEntry(QString fullPath) = 0;

  /** Rename a node */
  virtual bool rename(QString path, QString newName) = 0;

  /** Delete a node */
  virtual void del(QString path) = 0;

  /** Returns the original URL of the stored file */
  virtual KURL sourceURL(QString path) = 0;

  /** Returns the Meta Info of the specified file */
  virtual KatalogInfoList readInfo(QString path) = 0;

  /** */
  virtual void stopJobs() = 0;

  /** Exits */
  virtual bool exit() = 0;

k_dcop_signals:
  /** Emitted when the creation of the catalog or the import/export is finished */
  void finished(QString);

  /** Notify the folder currently explored */
  void currentFolder(QString);

  /** Progress in exploration */
  void newItem();

  /**  */
  void totItems(int);
};
#endif
