/***************************************************************************
 *   Copyright (C) 2004 by Stefano Salvador                                *
 *   stefano@diamante                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef KATALOGSERVICEDLG_H
#define KATALOGSERVICEDLG_H

#include <kurl.h>

#include "katalogservicedlgbase.h"

class KatalogScan;
class KSystemTray;
class JobThread;

class KatalogServiceDlg : public KDialogServiceDlgBase
{
Q_OBJECT

friend class JobThread;

public:
  KatalogServiceDlg(QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
  ~KatalogServiceDlg();

  void setURL(KURL url);

  void customEvent( QCustomEvent * e );

private:
  void disableUI();
  void restoreUI();
  int m_currentStatus;
  bool m_scanning;
  int m_tot_items;
  int m_part_items;
  KURL m_url;
  KSystemTray *m_sysTray;
  KatalogScan *m_katalogscan;
  QString m_base_string;
  uint m_base_len;
  JobThread *m_jobThread;

  /** Enumerator for status */
  enum status { IDLE = 1, COUNT_FOLDERS = 2, SCANNING = 4 };

  /** Enumerator for codes in custom event */
  enum customEventTypes { TOT_ITEMS = QEvent::User, FATAL_ERROR };

protected slots:
  virtual void reject();
  virtual void accept();

private slots:
  void slotClose();
  void finished(QString);
  void currentFolder(QString);
  void newItem();

};

#endif

