#include <qcstring.h>
#include <qapplication.h>

#include <kdebug.h>
#include <kmessagebox.h>
#include <kinstance.h>
#include <kglobal.h>
#include <kstandarddirs.h>
#include <kmimetype.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kurl.h>

#include "katalogslave.h"

#include "katalogfs.h"
#include "kataloginfo.h"

using namespace KIO;

kio_katalogProtocol::kio_katalogProtocol(const QCString &pool_socket, const QCString &app_socket)
    : SlaveBase("kio_katalogslave", pool_socket, app_socket)
{
  // We need a QApplication for SQL connection
  int argc = 0;
  char *argv[0];
  m_app = new QApplication( argc, argv, FALSE );
}

kio_katalogProtocol::~kio_katalogProtocol()
{
  delete m_app;
}

void kio_katalogProtocol::get(const KURL& url )
{
  KatalogFS kFS;
  KatalogInfo kInfo;
  QStringList path = QStringList::split("/", url.path(), false);

  mimeType("text/html");

  data(QCString("<?xml version=\"1.0\" encoding=\"UTF8\"?>\n"));
  data(QCString("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n"));
  data(QCString("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n"));
  data(QCString("<head>\n"));
  data(QCString("  <title>Katalog :: Item Infos</title>\n"));
  data(QCString("  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF8\" />\n"));
  KStandardDirs dirs;
  QString cssFile = dirs.findResource("data", "katalog/katalog_info.css");
  data(QCString("  <link rel=\"stylesheet\" type=\"text/css\" href=\"file:///" + cssFile.utf8() + "\" />\n"));
  data(QCString("</head>\n"));
  data(QCString("<body>\n"));
  data(QCString("<div id=\"main\">\n"));
  data(QCString("  <div class=\"header\">\n"));
  data(QCString("    <img src=\"file:///" + kInfo.icon(path).utf8() + "\"/>\n" ));
  data(QCString("    <h2>" + path.last().utf8() + "</h2>\n")); // name
  data(QCString("  </div>\n"));
  data(QCString("  <div class=\"info\">\n"));
  data(QCString("    <ul>\n"));
  data(QCString("      <li><span class=\"i_key\">Size</span> <span class=\"i_value\">") + kInfo.prettySize(path).utf8() + "</span></li>\n");
  data(QCString("      <li><span class=\"i_key\">Modified</span> <span class=\"i_value\">") + kInfo.prettyDateTime(path).utf8() + "</span></li>\n");
  QString sourceUrl = kInfo.sourceURL(path).url();
  data(QCString("      <li><span class=\"i_key\">Location</span> <a class=\"i_value\" href=\"") + sourceUrl.utf8() + "\">" + sourceUrl.utf8() + "</a></li>\n");
  data(QCString("    </ul>\n"));
  data(QCString("  </div>\n"));

  data(QCString("  <div class=\"metainfo\">\n"));
  data(QCString("    <h2>Meta Info</h2>\n"));
  KatalogInfoList kInfoList = kInfo.readInfo(path);
  KatalogInfoList::iterator it;
  QString groupName;
  bool first = true;
  for ( it = kInfoList.begin(); it != kInfoList.end(); ++it ) {
    KatalogInfoItem info = (*it);
    if( groupName != info[0].toString() ) {
      groupName = info[0].toString();
      if(first)
        first = false;
      else
        data(QCString("    </ul>\n"));
      data(QCString("    <h3>") + groupName.utf8() + "</h3>\n");
      data(QCString("    <ul>\n"));
    }
    data(QCString("      <li><span class=\"mi_key\">") + info[1].toString().utf8() + "</span> <span class=\"mi_value\">" + info[3].toString().utf8() + "</span></li>\n");
  }
  data(QCString("    </ul>\n"));
  data(QCString("  </div>\n"));

  data(QCString("</div>\n"));
  data(QCString("</body>\n"));
  data(QCString("</html>\n"));

  finished();
}

// stat is used by the client to decide if the url
// refers to a file or a dir.
void kio_katalogProtocol::stat( const KURL & url )
{
  QStringList path = QStringList::split("/", url.path(), false);

  KatalogFS kFS;

  KatalogUDSEntry *entry = new KatalogUDSEntry(kFS.stat(path));
  if(entry->isEmpty()) {
    error( KIO::ERR_DOES_NOT_EXIST, url.prettyURL() );
    return;
  }

  UDSEntry *e = (UDSEntry *)entry;

  statEntry(*e);

  delete entry;

  finished();
}

// listDir list the contents of the url passed
// as argument (if it's a dir, see stat), to costruct a tree
// call recursively this method.
void kio_katalogProtocol::listDir( const KURL& url)
{
  QStringList path = QStringList::split("/", url.path(), false);

  KatalogFS kFS;
  KatalogUDSEntryList *entries = new KatalogUDSEntryList(kFS.list(path));

  totalSize( entries->count() );

  UDSEntryList *ue = (UDSEntryList *)entries;

  UDSEntryListConstIterator it;
  for ( it = ue->begin(); it != ue->end(); ++it )
    listEntry( *it, false );

  listEntry( *it, true );

  delete entries;

  finished();
}

void kio_katalogProtocol::rename(const KURL &url, const KURL &dest, bool overwrite)
{
  QString pathIn = url.path();
  pathIn = pathIn.left(pathIn.findRev('/', -2));
  QString pathOut = dest.path();
  pathOut = pathOut.left(pathOut.findRev('/', -2));

  if(pathIn != pathOut)
  {
    error( KIO::ERR_CANNOT_RENAME, url.prettyURL() );
    return;
  }

  if(url.protocol() != "katalog" || dest.protocol() != "katalog")
  {
    error( KIO::ERR_UNSUPPORTED_PROTOCOL, url.prettyURL() );
    return;
  }

  if(url.fileName() == dest.fileName())
  {
    error( KIO::ERR_IDENTICAL_FILES, url.prettyURL() );
    return;
  }

  QStringList path = QStringList::split("/", url.path(), false);
  QString name = dest.fileName();

  KatalogFS kFS;
  if( !kFS.rename(path, name) ) {
    error( KIO::ERR_CANNOT_RENAME, url.prettyURL() );
    return;
  }

  finished();
}

void kio_katalogProtocol::del(const KURL & url, bool)
{
  KatalogFS kFS;
  QStringList path = QStringList::split("/", url.path(), false);
  kFS.del(path);
  finished();
}

extern "C"
{
  int kdemain(int argc, char **argv)
  {
    KInstance instance( "kio_katalogslave" );
    if (argc != 4) {
      exit(-1);
    }

    kio_katalogProtocol slave(argv[2], argv[3]);
    slave.dispatchLoop();

    return 0;
  }
}
