/***************************************************************************
 *   Copyright (C) 2004 by Stefano Salvador                                *
 *   stefano.salvador@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qfile.h>

#include <kgenericfactory.h>
#include <kdebug.h>

#include <kataloginfo.h>

#include "kfile_katalog.h"

#define DIR "inode/katalog-directory"
#define KATALOG "application/x-katalog"
#define ITEM "application/x-katalogitem"

typedef KGenericFactory<katalogPlugin> katalogFactory;

K_EXPORT_COMPONENT_FACTORY(kfile_katalog, katalogFactory( "kfile_katalog" ));

katalogPlugin::katalogPlugin(QObject *parent, const char *name, const QStringList &args)
  : KFilePlugin(parent, name, args)
{
  m_katalog = new KatalogInfo();
  m_info_dir = addMimeTypeInfo( DIR );
  m_info_katalog = addMimeTypeInfo( KATALOG );
  m_info_item = addMimeTypeInfo( ITEM );
}

bool katalogPlugin::readInfo( KFileMetaInfo& infoMeta, uint /*what*/)
{
  KatalogInfoList data = retriveData(infoMeta.url());

  KFileMimeTypeInfo *infoMime = 0;
  QString mime = infoMeta.mimeType();
  if(mime.compare(DIR) == 0)
    infoMime = m_info_dir;
  else if(mime.compare(KATALOG) == 0)
    infoMime = m_info_katalog;
  else if(mime.compare(ITEM) == 0)
    infoMime = m_info_item;

  if(infoMime)
    return readInfo(infoMime, infoMeta, data);

  return false;
}

bool katalogPlugin::readInfo(KFileMimeTypeInfo *infoMime, KFileMetaInfo& infoMeta, KatalogInfoList& data)
{
  KatalogInfoList::iterator it;
  QString groupName;
  KFileMimeTypeInfo::GroupInfo* groupMime;
  KFileMetaInfoGroup groupMeta;
  for ( it = data.begin(); it != data.end(); ++it ) {
    KatalogInfoItem info = (*it);
    if( groupName != info[0].toString() ) {
      groupName = info[0].toString();
      groupMime = addGroupInfo(infoMime, groupName, groupName);
      groupMeta = appendGroup(infoMeta, groupName);
    }
    QString itemKey = info[1].toString();
    KFileMimeTypeInfo::ItemInfo* itemMime = 0L;
    itemMime = addItemInfo( groupMime, itemKey, itemKey, info[3].type() );
    appendItem(groupMeta, itemKey, info[3]);
    setUnit(itemMime, info[4].toInt());
  }
  return true;
}

KatalogInfoList katalogPlugin::retriveData(KURL url)
{
  QStringList path = QStringList::split("/", url.path(), false);
  return m_katalog->readInfo(path);
}
