/***************************************************************************
 *   Copyright (C) 2004-2006 by Stefano Salvador                           *
 *   stefano.salvador@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qsqldriver.h>

#include "katalogfs.h"

KatalogUDSEntryList KatalogFS::list(QStringList path)
{
  openDB();
  KatalogUDSEntryList l;
  if(path.empty()){
    KatalogEntry entry_c, entry_m;
    QSqlQuery query(QString("SELECT MAX(creationdate), MAX(lastupdatedate) FROM catalogs"));
    int mod_time = 0;
    int acc_time = 0;
    if ( query.isActive() && query.first()) {
      mod_time = query.value(0).toInt();
      acc_time = query.value(1).toInt();
    }
    entry_c["filetype"] = "inode/katalog-directory";
    entry_c["filename"] = "catalogs";
    entry_c["filesize"] = 0;
    entry_c["modificationdate"] = mod_time;
    entry_c["lastaccessdate"] = acc_time;
    entry_c["username"] = "stefano";
    entry_c["groupname"] = "users";
    l.append( createUDSEntry(entry_c) );
    entry_m["filetype"] = "inode/katalog-directory";
    entry_m["filename"] = "mimetypes";
    entry_m["filesize"] = 0;
    entry_m["modificationdate"] = mod_time;
    entry_m["lastaccessdate"] = acc_time;
    l.append( createUDSEntry(entry_m) );
    return l;
  }
  QString type = path.first();
  path.pop_front();
  if(type == "catalogs"){
    KatalogNode node = findNode(path);
    if(node.catalogid == -1){
      QSqlQuery query("SELECT name, creationdate, lastupdatedate FROM catalogs");
      if ( query.isActive() ) {
        while ( query.next() ) {
          KatalogEntry entry;
          entry["filetype"] = "inode/katalog-directory";
          entry["filename"] = query.value(0);
          entry["filesize"] = 0;
          entry["modificationdate"] = query.value(1);
          entry["lastaccessdate"] = query.value(2);
          l.append( createUDSEntry(entry) );
        }
      }
    }
    else{
      QSqlQuery query(QString("SELECT fileid, filetype, filename, filesize, modificationdate, lastaccessdate, username, groupname, permissions FROM files WHERE catalogid='%1' AND parentid='%2'").arg(node.catalogid).arg(node.fileid));
      if ( query.isActive() ) {
        while ( query.next() ) {
          KatalogEntry entry;
          if(query.value(1).toString() == "inode/directory"){
            entry["filetype"] = "inode/katalog-directory";
          }
          else{
            QSqlQuery query2(QString("SELECT COUNT(*) FROM files WHERE catalogid='%1' AND parentid='%2'").arg(node.catalogid).arg(query.value(0).toInt()));
            query2.first();
            if(query2.value(0).toInt() > 0){
              entry["filetype"] = "inode/katalog-directory";
            }
            else
              entry["filetype"] = "application/x-katalogitem";
          }
          entry["filename"] = query.value(2);
          entry["filesize"] = query.value(3);
          entry["modificationdate"] = query.value(4);
          entry["lastaccessdate"] = query.value(5);
          l.append( createUDSEntry(entry) );
        }
      }
    }
  }
  else if(type == "mimetypes"){
    int len = path.count();
    if(len == 0){
      QSqlQuery query("SELECT filetype FROM files WHERE filetype != 'inode/directory' GROUP BY filetype;");
      QStringList groups;
      if ( query.isActive() ) {
        while ( query.next() ) {
          QString mimetype = query.value(0).toString();
          QString group = mimetype.left( mimetype.find('/') );
          if(groups.find(group) == groups.end()){
            groups.append(group);
            KatalogEntry entry;
            entry["filetype"] = "inode/katalog-directory";
            entry["filename"] = group;
            entry["filesize"] = 0;
            entry["modificationdate"] = 0;
            entry["lastaccessdate"] = 0;
            l.append( createUDSEntry(entry) );
          }
        }
      }
    }
    else if(len == 1){
      QString group = path.first();
      QSqlQuery query(QString("SELECT filetype FROM files WHERE filetype LIKE '%1/%' GROUP BY filetype;").arg(group));
      if ( query.isActive() ) {
        while ( query.next() ) {
          QString mimetype = query.value(0).toString();
          QString category = mimetype.right( mimetype.length() - mimetype.find('/') - 1 );
          KatalogEntry entry;
          entry["filetype"] = "inode/katalog-directory";
          entry["filename"] = category;
          entry["filesize"] = 0;
          entry["modificationdate"] = 0;
          entry["lastaccessdate"] = 0;
          l.append( createUDSEntry(entry) );
        }
      }
    }
    else if(len == 2){
      QSqlQuery query(QString("SELECT fileid, filetype, filename, filesize, modificationdate, lastaccessdate FROM files WHERE filetype = '%1'").arg(path.join("/")));
      if ( query.isActive() ) {
        while ( query.next() ) {
          KatalogEntry entry;
          if(query.value(1).toString() == "inode/directory"){
            entry["filetype"] = "inode/katalog-directory";
          }
          else{
            entry["filetype"] = "application/x-katalogitem";
          }
          entry["filename"] = query.value(2);
          entry["filesize"] = query.value(3);
          entry["modificationdate"] = query.value(4);
          entry["lastaccessdate"] = query.value(5);
          l.append( createUDSEntry(entry) );
        }
      }
    }
  }
  return l;
}

KatalogUDSEntry KatalogFS::stat(QStringList path)
{
  openDB();
  KatalogEntry entry;
  int len = path.count();
  if(len == 0){
    entry["filetype"] = "inode/katalog-directory";
    entry["filename"] = "";
    entry["filesize"] = 0;
    QSqlQuery query(QString("SELECT MAX(creationdate), MAX(lastupdatedate) FROM catalogs"));
    if ( query.isActive() && query.first()) {
      entry["modificationdate"] = query.value(0).toInt();
      entry["lastaccessdate"] = query.value(1).toInt();
    }
    return createUDSEntry(entry);
  }
  QString type = path.first();
  path.pop_front();
  if(type = "catalogs"){
    KatalogNode node = findNode(path);
    if(node.catalogid == -1){
      entry["filetype"] = "inode/katalog-directory";
      entry["filename"] = "catalogs";
      entry["filesize"] = 0;
      QSqlQuery query(QString("SELECT MAX(creationdate), MAX(lastupdatedate) FROM catalogs"));
      if ( query.isActive() && query.first()) {
        entry["modificationdate"] = query.value(0).toInt();
        entry["lastaccessdate"] = query.value(1).toInt();
      }
      return createUDSEntry(entry);
    }
    else if(node.fileid == -1){
      QSqlQuery query(QString("SELECT name, creationdate, lastupdatedate FROM catalogs WHERE catalogid='%1'").arg(node.catalogid));
      query.first();
      entry["filetype"] = "inode/katalog-directory";
      entry["filename"] = query.value(0);
      entry["filesize"] = 0;
      entry["modificationdate"] = query.value(1).toInt();
      entry["lastaccessdate"] = query.value(2).toInt();
      return createUDSEntry(entry);
    }
    else {
      QSqlQuery query(QString("SELECT fileid, filetype, filename, filesize, modificationdate, lastaccessdate, username, groupname, permissions FROM files WHERE catalogid='%1' AND fileid='%2'").arg(node.catalogid).arg(node.fileid));
      query.first();
      if(query.value(1).toString() == "inode/directory"){
        entry["filetype"] = "inode/katalog-directory";
      }
      else {
        QSqlQuery query2(QString("SELECT COUNT(*) FROM files WHERE catalogid='%1' AND parentid='%2'").arg(node.catalogid).arg(query.value(0).toInt()));
        query2.first();
        if(query2.value(0).toInt() > 0)
          entry["filetype"] = "inode/katalog-directory";
        else
          entry["filetype"] = "application/x-katalogitem";
      }
      entry["filename"] = query.value(2);
      entry["filesize"] = query.value(3);
      entry["modificationdate"] = query.value(4);
      entry["lastaccessdate"] = query.value(5);
      return createUDSEntry(entry);
    }
  }
  else if(type == "mimetypes"){
    int len = path.count();
    if(len == 0){
      entry["filetype"] = "inode/katalog-directory";
      entry["filename"] = "mimetypes";
      entry["filesize"] = 0;
      QSqlQuery query(QString("SELECT MAX(creationdate), MAX(lastupdatedate) FROM catalogs"));
      if ( query.isActive() && query.first()) {
        entry["modificationdate"] = query.value(0);
        entry["lastaccessdate"] = query.value(1);
      }
      return createUDSEntry(entry);
    }
    else if(len == 1){
      QString group = path.first();
      entry["filetype"] = "inode/katalog-directory";
      entry["filename"] = group;
      entry["filesize"] = 0;
      return createUDSEntry(entry);
    }
    else if(len == 2){
      QString category = path[1];
      entry["filetype"] = "inode/katalog-directory";
      entry["filename"] = category;
      entry["filesize"] = 0;
      return createUDSEntry(entry);
    }
    else {
      QSqlQuery query(QString("SELECT fileid, filetype, filename, filesize, modificationdate, lastaccessdate FROM files WHERE filetype = '%1' AND filename='%2'").arg(path[0] + '/' + path[1]).arg(path[2]));
      if ( query.isActive() && query.first() ) {
        KatalogEntry entry;
        if(query.value(1).toString() == "inode/directory"){
          entry["filetype"] = "inode/katalog-directory";
        }
        else{
          entry["filetype"] = "application/x-katalogitem";
        }
        entry["filename"] = query.value(2);
        entry["filesize"] = query.value(3);
        entry["modificationdate"] = query.value(4);
        entry["lastaccessdate"] = query.value(5);
        return createUDSEntry(entry);
      }
    }
  }

  // Failed searching entry
  KatalogUDSEntry e;
  e.clear();
  return e;
}

bool KatalogFS::rename(QStringList path, QString newName)
{
  int size = path.size();
  if(size < 2){
    // We can rename the base folders structure
    return false;
  }
  QString type = path.first();
  path.pop_front();
  if(type = "catalogs"){
    openDB();
    KatalogNode node = findNode(path);
    if(node.catalogid == -1){
      // This is the root or the path does not exist, we can rename it !!!
      return false;
    }
    else if(node.fileid == -1 && size == 2){
      // Rename the catalog
      QSqlQuery query(QString("UPDATE catalogs SET name = '%1' WHERE catalogid = '%2'").arg(newName).arg(node.catalogid));
      bool res = query.isActive();
      return res;
    }
    else if(node.fileid != -1 && size > 2){
      // Rename the file or folder
      QSqlQuery query(QString("UPDATE files SET filename='%1', fullname = substr(fullname, 0, length(fullname)-length(filename)) || '%2' WHERE fileid = '%3'").arg(newName).arg(newName).arg(node.fileid));
      bool res = query.isActive();
      return res;
    }
    else{
      // Wrong path
      return false;
    }
  }
  else if(type = "mimetypes"){
    // It's not possible to rename files in mimetypes folder
    return false;
  }
  else{
    // Undefined case, we can arrive here, isn't it?
    return false;
  }
}

void KatalogFS::del(QStringList path)
{
  if(path.size() < 2){
    // We can not delete the base folders structure
    return;
  }
  QString type = path.first();
  path.pop_front();
  if(type = "catalogs"){
    openDB();
    KatalogNode node = findNode(path);
    if(node.catalogid == -1){
      // This is the root or the path does not exist, we can not delete it !!!
      return;
    }
    else if(node.fileid == -1){
      // Remove the catalog
      QSqlQuery query(QString("DELETE FROM catalogs WHERE catalogid = '%1'").arg(node.catalogid));
    }
    else {
      // Delete the file or folder ...
      QSqlQuery queryF(QString("DELETE FROM files WHERE fileid = '%1'").arg(node.fileid));
      // ... then delete metadata
      QSqlQuery queryM(QString("DELETE FROM metadata WHERE fileid = '%1'").arg(node.fileid));
    }
  }
  else if(type = "mimetypes"){
    // It's not possible to delete files in mimetypes folder
  }
  else{
    // Undefined case, we can not arrive here, isn't it?
  }
}

KatalogUDSEntry KatalogFS::createUDSEntry(KatalogEntry node) const
{
  KatalogUDSEntry entry;
  entry.clear();
  QString type = node["filetype"].toString();

  KatalogUDSAtom atom;
  atom.m_uds = UDS_NAME;
  atom.m_str = node["filename"].toString();
  entry.append( atom );

  atom.m_uds = UDS_FILE_TYPE;
  if(type == "inode/katalog-directory")
    atom.m_long = S_IFDIR;
  else
    atom.m_long = S_IFREG;

  entry.append( atom );

  atom.m_uds = UDS_MODIFICATION_TIME;
  atom.m_long = node["modificationdate"].toInt();
  entry.append( atom );

  atom.m_uds = UDS_ACCESS_TIME;
  atom.m_long = node["lastaccessdate"].toInt();
  entry.append( atom );

  atom.m_uds = UDS_SIZE;
  atom.m_long = node["filesize"].toInt();
  entry.append( atom );

  atom.m_uds = UDS_MIME_TYPE;
  atom.m_str = type;
  entry.append( atom );

  atom.m_uds = UDS_ACCESS;
  atom.m_long = 0600;
  entry.append( atom );

  return entry;
}
