/***************************************************************************
 *   Copyright (C) 2004-2006 by Stefano Salvador                           *
 *   stefano.salvador@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KATALOGFS_H
#define KATALOGFS_H

#include <qstring.h>
#include <qstringlist.h>

#include <kio/job.h>

#include "katalogiface.h"
#include "kataloguds.h"

class KatalogFS : public KatalogIFace
{
public:
  /** Get the list of contents in a node */
  KatalogUDSEntryList list(QStringList fullPath);

  /** Get the given entry */
  KatalogUDSEntry stat(QStringList fullPath);

  /** Rename a node */
  bool rename(QStringList path, QString newName);

  /** Delete a node */
  void del(QStringList path);

private:
  KatalogUDSEntry createUDSEntry(KatalogEntry entry) const;
};

#endif
