/***************************************************************************
 *   Copyright (C) 2004-2006 by Stefano Salvador                           *
 *   stefano.salvador@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KATALOGIFACE_H
#define KATALOGIFACE_H

#include <qdatetime.h>

#include "katalogdefs.h"

class QSqlDatabase;

class KatalogIFace
{
public:
  KatalogIFace();

  virtual  ~KatalogIFace();

  /** General success constant */
  static const int SUCCESS = 0;

  /** Adds a catalog */
  int addCatalog(QString name, QString baseUrl, QDateTime date = QDateTime::currentDateTime());

  bool isReady() { return openDB(); }

protected:
  /** Opens the connection with the database containing katalog info */
  bool openDB();

  /** Find node relative to path */
  KatalogNode findNode(QStringList& path) const;

private:
  /** Creates the database for storing katalog info */
  bool createDB();

  bool m_isOpen;

};

#endif
