/***************************************************************************
 *   Copyright (C) 2004-2006 by Stefano Salvador                           *
 *   stefano.salvador@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KATALOGINFO_H
#define KATALOGINFO_H

#include <qstring.h>
#include <qstringlist.h>

#include "katalogiface.h"
#include "katalogdefs.h"

class KatalogInfo : public KatalogIFace{
public:
  /** Request the number of folders */
  int countFolders(const KURL& mount);

  /** Returns generic infos of the stored file */
  QVariant getInfo(const QString& info, const QStringList& path);

  /** Returns the size (in bytes) of the stored file */
  int size(const QStringList& path);

  /** Returns string representation of the size of the stored file */
  QString prettySize(const QStringList& path);

  /** Returns the date (t_time) of the stored file */
  uint dateTime(const QStringList& path);

  /** Returns string representation of the size of the stored file */
  QString prettyDateTime(const QStringList& path);

  /** Returns the mimetype of the stored file */
  QString mimetype(const QStringList& path);

  /** Returns the icon name of the stored file */
  QString icon(const QStringList& path);

  /** Returns the original URL of the stored file */
  KURL sourceURL(const QStringList& path);

  /** Returns the Meta Info of the specified file */
  KatalogInfoList readInfo(const QStringList& path);

  /** Get the list of available catalogs */
  QStringList getCatalogsList();

  /** Stop current operation */
  void stopJobs();

private:
  int totalItems(const QString& catalog);
  int totalCatalogs();
  void _countFolders(const QString& path, int &totFolders);
  bool m_stop;
};

#endif
