/***************************************************************************
 *   Copyright (C) 2004-2006 by Stefano Salvador                           *
 *   stefano.salvador@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qsqlquery.h>
#include <qsqldriver.h>
#include <qsqldatabase.h>

#include <kio/global.h>
#include <kdebug.h>

#include "katalogio.h"

KatalogIO::KatalogIO():KatalogIFace()
{
}

KatalogIO::~KatalogIO()
{
}

int KatalogIO::getNextFileId(){
  QSqlQuery query_max("SELECT MAX(fileid) FROM files");
  int fileid = 1;
  if(query_max.first())
    fileid = query_max.value(0).toInt() + 1;
  return fileid;
}

void KatalogIO::initInput(){
  openDB();
  QSqlDatabase *db = QSqlDatabase::database();
  bool hasTransactions = db->driver()->hasFeature(QSqlDriver::Transactions);
  if(hasTransactions)
    db->transaction();
}

void KatalogIO::doneInput(){
  QSqlDatabase *db = QSqlDatabase::database();
  bool hasTransactions = db->driver()->hasFeature(QSqlDriver::Transactions);
  if(hasTransactions)
    db->commit();
}


int KatalogIO::addEntry(FileInfoDB& item)
{
  kdDebug() <<  item.fileid << endl;
//   kdDebug() <<  file_id_q.isValid() << endl;
//   kdDebug() <<  file_id_q.isActive() << endl;
//   kdDebug() << "KatalogIO::addEntry - " << file_id_q.lastError().text() << endl;
//   kdDebug() << "KatalogIO::addEntry - " << file_id_q.executedQuery() << endl;

  QSqlQuery query_add_file;
  query_add_file.prepare( "INSERT INTO files ("
      "fileid, catalogid, fullname, filename, parentid, filetype, filesize, statuschangedate,"
      "modificationdate, lastaccessdate, lastupdatedate, username, groupname, permissions, mode, language) "
      "VALUES ("
      ":fileid, :catalogid, :fullname, :filename, :parentid, :filetype, :filesize, :statuschangedate,"
      ":modificationdate, :lastaccessdate, :lastupdatedate, :username, :groupname, :permissions, :mode, :language) " );
  query_add_file.bindValue( ":fileid", item.fileid );
  query_add_file.bindValue( ":catalogid", item.catalogid );
  query_add_file.bindValue( ":fullname", item.fullname );
  query_add_file.bindValue( ":filename", item.filename );
  query_add_file.bindValue( ":parentid", item.parentid );
  query_add_file.bindValue( ":filetype", item.filetype );
  query_add_file.bindValue( ":filesize", item.filesize );
  query_add_file.bindValue( ":statuschangedate", 0 );
  query_add_file.bindValue( ":modificationdate", item.modificationdate );
  query_add_file.bindValue( ":lastaccessdate", item.lastaccessdate );
  query_add_file.bindValue( ":lastupdatedate", 0 );
  query_add_file.bindValue( ":username", item.username );
  query_add_file.bindValue( ":groupname", item.groupname );
  query_add_file.bindValue( ":permissions", item.permissions );
  query_add_file.bindValue( ":mode", 0 ); // TODO ???
  query_add_file.bindValue( ":language", 0 ); // TODO ???
  query_add_file.exec();

  kdDebug() <<  query_add_file.executedQuery() << endl;
  kdDebug() <<  query_add_file.lastError().databaseText() << endl;
  kdDebug() <<  query_add_file.lastError().driverText() << endl;
//   kdDebug() <<  query.isValid() << endl;
//   kdDebug() <<  query.isActive() << endl;

  return item.fileid;
}

void KatalogIO::addInfo(MetaInfoDB& minfo)
{
  openDB();
  QSqlQuery query_add_info;
  query_add_info.prepare("INSERT INTO metadata (fileid, groupname, field, type, value, unit) VALUES (:fileid, :groupname, :field, :type, :value, :unit)");
  query_add_info.bindValue( ":fileid", minfo.fileid );
  query_add_info.bindValue( ":groupname", minfo.groupname );
  query_add_info.bindValue( ":field", minfo.field );
  query_add_info.bindValue( ":type", minfo.type );
  query_add_info.bindValue( ":value", minfo.value );
  query_add_info.bindValue( ":unit", minfo.unit );
  query_add_info.exec();
}
