/***************************************************************************
 *   Copyright (C) 2004-2006 by Stefano Salvador                           *
 *   stefano.salvador@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KATALOGIO_H
#define KATALOGIO_H

#include <kfileitem.h>

#include "katalogiface.h"

struct MetaInfoDB {
  int fileid;
  QString groupname;
  QString field;
  QString type;
  QString value;
  int unit;
};

struct FileInfoDB {
  int parentid;
  int fileid;
  int catalogid;
  QString fullname;
  QString filename;
  QString filetype;
  int filesize;
  uint modificationdate;
  uint lastaccessdate;
  QString username;
  QString groupname;
  int permissions;
};

class QSqlQuery;

class KatalogIO : public KatalogIFace{
public:
  KatalogIO();
  ~KatalogIO();

  void initInput();

  void doneInput();

  int getNextFileId();

  /** Add a new entry to the database */
  int addEntry(FileInfoDB& item);

  /** Add metainfo associated to an existing entry */
  void addInfo(MetaInfoDB& minfo);

private:
  QSqlQuery * m_query_max;
  QSqlQuery * m_query_add_file;
  QSqlQuery * m_query_add_info;
};

#endif
