/***************************************************************************
 *   Copyright (C) 2004-2006 by Stefano Salvador                           *
 *   stefano.salvador@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KATALOGSCAN_H
#define KATALOGSCAN_H

#include <qobject.h>
#include <qstring.h>

#include <kurl.h>
#include <kio/job.h>

#include "katalogiface.h"
#include "katalogdefs.h"

class KIO::ListJob;

class KatalogScan : public QObject, public KatalogIFace{
Q_OBJECT
public:
  /** Adds the items found in mount to the catalog, creating it if not exist */
  int start( const KURL& mount,
             QString catalog,
             bool exploreArchives = false,
             bool getMetaInfo = false);

  /** Stops the current scan */
  void stopJobs();

private:
  /** List of open jobs */
  KatalogJobs m_jobs;

  /** Map of usefull ids */
  KatalogIds m_fileids;

  /** Cache of the current url */
  KURL m_currentUrl;

  /** Cache of the current file id */
  int m_current_fileid;

  /** Cache of the current catalog id */
  int m_current_catalogid;

  /** Cache of the current ListDir job */
  KIO::ListJob * m_current_job;

  /** Flag: true for exploring compressed archives */
  bool m_exploreArchives;

  /** Flag: true for reading and storing Meta Infos */
  bool m_getMetaInfo;

private slots:
  void slotEntries(KIO::Job *, const KIO::UDSEntryList &);
  void slotResult(KIO::Job *);
  void slotRedirection(KIO::Job *, const KURL&);

signals:
  /** Emitted when the creation of the catalog is finished */
  void finished(QString);

  /** Notify the folder currently explored */
  void currentFolder(QString);

  /** Progress in exploration */
  void newItem();
};

#endif
