
#include <qlayout.h>
#include <qpushbutton.h>
#include <qfile.h>

#include <kapplication.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <dcopclient.h>
#include <kdebug.h>
#include <kpassivepopup.h>
#include <kprotocolinfo.h>

#include <kataloguds.h>
#include "kataloginfo.h"
#include "main.h"

QCString appId;
DCOPClient *client;

#include <qthread.h>

class JobThread : public QThread {

public:
  JobThread(QWidget *obj){th_obj = obj;}
  virtual void run();
private:
  QWidget *th_obj;
};

void JobThread::run()
{
  int i = 0;
  while(i < 10)
  {
    sleep(2);
    QCustomEvent *event = new QCustomEvent(QEvent::User + 1);
    QApplication::postEvent(th_obj, event);
  }
}


KatalogTest::KatalogTest( QWidget *parent, const char *name )
  : QWidget( parent, name )
{
//  k = new Katalog();
  QStringList path = QStringList::split("/", "/catalogs/DOCS/Vacanze/tarvisio.png");

  KatalogInfo info;

  QVariant i = info.getInfo("filetype", path);
  KMimeType::Ptr ptr = KMimeType::mimeType(i.toString());
  QString icon = ptr ? ptr->icon(QString::null, true) : QString::null;
  QString iconp = KGlobal::iconLoader()->iconPath(icon, 0);

  QPushButton* start1 = new QPushButton( "Create !!!", this );
  QPushButton* start2= new QPushButton( "List ...", this );
  p_start3= new QPushButton( "Direct ...", this );
  QPushButton* start4= new QPushButton( "Info ...", this );
  QPushButton* test = new QPushButton( "Quit", this );

  QVBoxLayout* layout = new QVBoxLayout( this );

  layout->addWidget( start1 );
  layout->addWidget( start2 );
  layout->addWidget( p_start3 );
  layout->addWidget( start4 );
  layout->addWidget( test );
  resize( layout->sizeHint() );
  connect( start1, SIGNAL( clicked() ), SLOT( start1() ) );
  connect( start2, SIGNAL( clicked() ), SLOT( start2() ) );
  connect( p_start3, SIGNAL( clicked() ), SLOT( start3() ) );
  connect( start4, SIGNAL( clicked() ), SLOT( start4() ) );
  connect( test, SIGNAL( clicked() ), SLOT( test() ) );

}

KatalogTest::~KatalogTest()
{
}

void KatalogTest::customEvent( QCustomEvent * e )
{
  p_start3->setText(QString("Direct %1").arg(++count));
}

void KatalogTest::start4()
{
  QStringList path = QStringList::split("/", "/catalogs/DOCS/lettera.log");
  KatalogInfo i;
}

void KatalogTest::start3()
{
  count = 0;
  JobThread *th = new JobThread(this);
  th->start();
//  k->initDocument( KURL("file:/home/stefano/bug4.xml.gz") );
//  m_items = 0;
//  kdDebug() << "start3" << endl;
//  k->addItems( KURL("file:/home/stefano/mp3"), "CONFS", false, false);
//  connect( k, SIGNAL( finished(QString) ), SLOT( slotFinished(QString) ) );
//  connect( k, SIGNAL( currentFolder(QString) ), SLOT( slotCurrentFolder(QString) ) );
//  connect( k, SIGNAL( newItem() ), SLOT( slotNewItem() ) );
}

void KatalogTest::start1()
{
//  k->addItems( KURL("file:/home/stefano/img"), "Immagini", true, true);
//  connect( k, SIGNAL( finished() ), SLOT( slotFinished() ) );
  // <DCOP>
  QByteArray data, replyData;
  QCString replyType;
  QDataStream arg(data, IO_WriteOnly);
  KURL openUrl;
  openUrl.setPath("/home/stefano/mp3");
  openUrl.setProtocol("file");
  arg << openUrl << "DCOP" << false << false;

  if (!client->call("katalogdcop", "katalogdcopInterface", "addItems(KURL, QString, bool, bool)",
            data, replyType, replyData))
  {
    return;
  }
  else {
    QDataStream reply(replyData, IO_ReadOnly);
    if (replyType == "int") {
      int result;
      reply >> result;
    }
  }
  // </DCOP>
}

void KatalogTest::start2()
{
  QStringList path = QStringList::split("/", "/catalogs/TEST GZ/");
}

void KatalogTest::test()
{
  close();
}

void KatalogTest::slotFinished(QString name)
{
}

void KatalogTest::slotCurrentFolder(QString name)
{
}

void KatalogTest::slotNewItem()
{
}

int main ( int argc, char *argv[] )
{
  KApplication app( argc, argv, "kdirlistertest" );
  client = app.dcopClient();
  client->attach();
  appId = client->registerAs(app.name());

  KatalogTest *test = new KatalogTest( 0 );
  test->show();
  app.setMainWidget( test );
  return app.exec();
}

#include "main.moc"
