#include <qcstring.h>
#include <qsocket.h>
#include <qdatetime.h>
#include <qbitarray.h>
#include <qfile.h>
#include <qdom.h>

#include <stdlib.h>
#include <math.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <iostream>

#include <kapplication.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <kinstance.h>
#include <kglobal.h>
#include <kstandarddirs.h>
#include <klocale.h>
#include <kurl.h>
#include <ksock.h>

#include "katalogxmlslave.h"

#include <katalogxml.h>

using namespace KIO;

kio_katalogxmlProtocol::kio_katalogxmlProtocol(const QCString &pool_socket, const QCString &app_socket)
    : SlaveBase("kio_katalogslave", pool_socket, app_socket)
{
  m_katalogFile = 0L;
}

kio_katalogxmlProtocol::~kio_katalogxmlProtocol()
{
  if(m_katalogFile)
    delete m_katalogFile;
}

bool kio_katalogxmlProtocol::checkNewFile( const KURL & url, QString & path )
{
  QString fullPath = url.path();

  // Are we already looking at that file ?
  if ( m_katalogFile && m_katalogName == fullPath.left(m_katalogName.length()) )
  {
    // Has it changed ?
    struct stat statbuf;
    if ( ::stat( QFile::encodeName( m_katalogName ), &statbuf ) == 0 )
    {
      if ( m_mtime == statbuf.st_mtime )
      {
        path = fullPath.mid( m_katalogName.length() );
        return true;
      }
    }
  }

  // Close previous file
  if ( m_katalogFile )
  {
    delete m_katalogFile;
    m_katalogFile = 0L;
  }

  // Find where the tar file is in the full path
  int pos = 0;
  QString katalogFile;
  path = QString::null;

  int len = fullPath.length();
  if ( len != 0 && fullPath[ len - 1 ] != '/' )
    fullPath += '/';

  while ( (pos=fullPath.find( '/', pos+1 )) != -1 )
  {
    QString tryPath = fullPath.left( pos );
    struct stat statbuf;
    if ( ::stat( QFile::encodeName(tryPath), &statbuf ) == 0 && !S_ISDIR(statbuf.st_mode) )
    {
      katalogFile = tryPath;
      m_mtime = statbuf.st_mtime;
      path = fullPath.mid( pos + 1 );
      len = path.length();
      if ( len > 1 )
      {
        if ( path[ len - 1 ] == '/' )
          path.truncate( len - 1 );
      }
      else
        path = QString::fromLatin1("/");
      break;
    }
  }

  if ( katalogFile.isEmpty() )
    return false;

  // Open new file
  if ( url.protocol() == "katalogxml" )
    m_katalogFile = new KatalogXML();
  else
    return false;

  KURL openUrl;
  openUrl.setProtocol("file");
  openUrl.setPath(katalogFile);

  if ( m_katalogFile->initDocument(openUrl) )
  {
    delete m_katalogFile;
    m_katalogFile = 0L;
    return false;
  }

  m_katalogName = katalogFile;
  return true;
}

void kio_katalogxmlProtocol::get(const KURL& url )
{}

// stat is used by the client to decide if the url
// refers to a file or a dir.
void kio_katalogxmlProtocol::stat( const KURL & url )
{
  QString path;
  if ( !checkNewFile( url, path ) )
  {
    QCString _path( QFile::encodeName(url.path()));
    struct stat buff;
    if ( ::stat( _path.data(), &buff ) == -1 || !S_ISDIR( buff.st_mode ) ) {
      error( KIO::ERR_DOES_NOT_EXIST, url.prettyURL() );
      return;
    }
    // It's a real dir -> redirect
    KURL redir;
    redir.setPath( url.path() );
    redirection( redir );
    finished();
    // And let go of the tar file - for people who want to unmount a cdrom after that
    delete m_katalogFile;
    m_katalogFile = 0L;
    return;
  }

  if ( path.isEmpty() )
  {
    KURL redir( url.protocol() + QString::fromLatin1( ":/") );
    redir.setPath( url.path() + QString::fromLatin1("/") );
    redirection( redir );
    finished();
    return;
  }

  QStringList list = QStringList::split("/", path);

  KatalogXMLUDSEntry *entry = new KatalogXMLUDSEntry(m_katalogFile->findEntry(list));
  if(entry->isEmpty()) {
    error( KIO::ERR_DOES_NOT_EXIST, url.prettyURL() );
    return;
  }

  UDSEntry *e = (UDSEntry *)entry;

  statEntry( *e );

  delete entry;

  finished();
}

// listDir list the contents of the url passed
// as argument (if it's a dir, see stat), to costruct a tree
// call recursively this method.
void kio_katalogxmlProtocol::listDir( const KURL& url)
{
  QString path;
  if ( !checkNewFile( url, path ) )
  {
    QCString _path( QFile::encodeName(url.path()));
    struct stat buff;
    if ( ::stat( _path.data(), &buff ) == -1 || !S_ISDIR( buff.st_mode ) ) {
      error( KIO::ERR_DOES_NOT_EXIST, url.prettyURL() );
      return;
    }
    // It's a real dir -> redirect
    KURL redir;
    redir.setPath( url.path() );
    redirection( redir );
    finished();

    // And let go of the file - for people who want to unmount a cdrom after that
    delete m_katalogFile;
    m_katalogFile = 0L;
    return;
  }

  QStringList list = QStringList::split("/", path);

  KatalogXMLUDSEntryList *entries = new KatalogXMLUDSEntryList(m_katalogFile->getNodeContent(list));

  totalSize( entries->count() );

  UDSEntryList *ue = (UDSEntryList *)entries;

  UDSEntryListConstIterator it;
  for ( it = ue->begin(); it != ue->end(); ++it )
    listEntry( *it, false );

  listEntry( *it, true ); // ready

  delete entries;

  finished();
}

extern "C"
{
  int kdemain(int argc, char **argv)
  {
    KInstance instance( "kio_katalogxmlslave" );
    if (argc != 4) {
      exit(-1);
    }

    kio_katalogxmlProtocol slave(argv[2], argv[3]);
    slave.dispatchLoop();

    return 0;
  }
}
