#ifndef _katalogslave_H_
#define _katalogslave_H_

#include <sys/types.h>
#include <sys/stat.h>

#include <stdio.h>
#include <unistd.h>

#include <qstring.h>
#include <qcstring.h>

#include <kurl.h>
#include <kio/global.h>
#include <kio/slavebase.h>

class QCString;

class KatalogXML;

class kio_katalogxmlProtocol : public KIO::SlaveBase
{
public:
  kio_katalogxmlProtocol(const QCString &pool_socket, const QCString &app_socket);
  virtual ~kio_katalogxmlProtocol();
  virtual void get(const KURL& url);
  virtual void stat(const KURL &);
  virtual void listDir(const KURL &);
protected:
  bool checkNewFile( const KURL & url, QString & path );
  KatalogXML * m_katalogFile;
  QString m_katalogName;
  time_t m_mtime;
};

#endif
