/***************************************************************************
 *   Copyright (C) 2004 by Stefano Salvador                                *
 *   stefano.salvador@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
       

#ifndef KFILE_KATALOG_H
#define KFILE_KATALOG_H

#include <sys/types.h>
     
#include <kfilemetainfo.h>
#include <kurl.h>
#include <dcopclient.h>

class QCString;
 
class QStringList;

class katalogxmlPlugin: public KFilePlugin
{
  public:
    katalogxmlPlugin( QObject *parent, const char *name, const QStringList& args );
    virtual ~katalogxmlPlugin();

    virtual bool readInfo( KFileMetaInfo& info, uint what);

  private:
    KFileMimeTypeInfo* m_info_dir;
    KFileMimeTypeInfo* m_info_kat;
    KFileMimeTypeInfo* m_info_item;
    KURL * m_katalogURL;

    QDomElement *retriveData(KURL url);
    bool readInfo(KFileMimeTypeInfo *infoMime, KFileMetaInfo& infoMeta, QDomElement * data);
    bool checkNewFile( const KURL & url, QString & path );
    KatalogXML * m_katalogFile;
    QString m_katalogName;
    time_t m_mtime;
};

#endif
