/***************************************************************************
 *   Copyright (C) 2004 by Stefano Salvador                                *
 *   stefano.salvador@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KATALOGUDSATOM_H
#define KATALOGUDSATOM_H

#include <kio/global.h>
#include <qdatastream.h>

using namespace KIO;

/**
@author Stefano Salvador
*/
class KatalogXMLUDSAtom : public UDSAtom{

private:
  friend QDataStream & operator<< (QDataStream & s, const KatalogXMLUDSAtom & a);
  friend QDataStream & operator>> (QDataStream & s, KatalogXMLUDSAtom & a);
};

QDataStream & operator<< (QDataStream & s, const KatalogXMLUDSAtom & a);
QDataStream & operator>> (QDataStream & s, KatalogXMLUDSAtom & a);

typedef QValueList<KatalogXMLUDSAtom> KatalogXMLUDSEntry;
typedef QValueList<KatalogXMLUDSEntry> KatalogXMLUDSEntryList;
typedef QValueListIterator<KatalogXMLUDSEntry> KatalogXMLUDSEntryListIterator;
typedef QValueListConstIterator<KatalogXMLUDSEntry> KatalogXMLUDSEntryListConstIterator;

#endif
