/***************************************************************************
                          birthdayeventdata.h  -  description
                             -------------------
    begin                : Tue Aug 6 2002
    copyright           : (C) 2002,2003 by Jan Hambrecht
    email                : jaham@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BIRTHDAYEVENTDATA_H
#define BIRTHDAYEVENTDATA_H

#include <qstring.h>
#include <qdatetime.h>
#include <qcolor.h>

/**
* @brief The data which is shown in the notification dialog.
* @author Jan Hambrecht
*/
class BirthdayEventData 
{
public: 
	/** @brief The standard constructor. */
	BirthdayEventData();
	
	/** @brief The constructor. */
	~BirthdayEventData();
	
	/** 
	* @brief Sets the event date. 
	* @param date the event date
	*/
	void setDate( const QDate &date );
	
	/** 
	* @brief Gets the event date. 
	* @return the event date
	*/
	QDate getDate();
	
	/** 
	* @brief Sets the event name. 
	* @param name the event name
	*/
	void setName( const QString &name );
	
	/** 
	* @brief Gets the event name. 
	* @return the event name
	*/
	QString getName();
	
	/** 
	* @brief Gets the event days to today. 
	* @return the event distance in days
	*/
	int &days();
	
	/** 
	* @brief Gets event years to today. 
	* @return the event distance in years
	*/
	int &years();
	
	/** 
	* @brief Gets the font color. 
	* @return the event font color
	*/
	QColor &color();
	
	/** 
	* @brief Sets the uid of the corresponding addressee. 
	* @param uid the event uid
	*/
	void setUid( const QString &uid );
	
	/** 
	* @brief Gets the uid of the corresponding addressee.
	* @return the event uid
	*/
	QString getUid();
private:
	
	/** @brief The date of this event. */
	QDate m_date;
	
	/** @brief The name of addressee. */
	QString m_name;
	
	/** @brief The difference in days. */
	int m_days;
	
	/** @brief The difference in years. */
	int m_years;
	
	/** @brief The font color. */
	QColor m_color;
	
	/** @brief The corresponding addressee uid. */
	QString m_uid;
};

#endif
