/***************************************************************************
                          birthdayitem.cpp  -  description
                             -------------------
    begin                : Tue Mar 5 2002
    copyright           : (C) 2002,2003 by Jan Hambrecht
    email                : jaham@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "birthdayitem.h"
#include <klocale.h>
#include <kglobal.h>

BirthdayItem::BirthdayItem( QListView *parent, BirthdayEventData &event )
	: QListViewItem( parent )
{
	// calculate key for sorting
	m_key = QString("%1").arg( event.days() + 1000, 3 );
	m_key = m_key.rightJustify( 10, '0', true );
	m_uid = event.getUid();
	
	// set event date
	setText( 0, KGlobal::locale()->formatDate( event.getDate(), true ) );
	// set name of addressee
	setText( 1, event.getName() );
	// set days to event
	int days = event.days();
	switch( days )
	{
		case -1: 
			setText( 2, i18n("yesterday") );
		break;
		case 0:
			setText( 2, i18n("today") );
		break;
		case 1: 
			setText( 2, i18n("tomorrow") );
		break;
		default:
			setText( 2, QString("%1").arg( days, 3 ) );
		break;
	}
	// set years to event
	setText( 3, QString("%1").arg( event.years(), 4 ) );
	// set color
	m_color = event.color();
}

BirthdayItem::~BirthdayItem()
{
}

void BirthdayItem::paintCell( QPainter *p, const QColorGroup & cg, int column, int width, int alignment )
{
	QColorGroup _cg( cg );
	QColor c = _cg.text();

	_cg.setColor( QColorGroup::Text, m_color );

	QListViewItem::paintCell( p, _cg, column, width, alignment );
	_cg.setColor( QColorGroup::Text, c );
}

QString BirthdayItem::key( int column, bool ) const
{
	if ( column == 0 || column == 2)
		return m_key;
	else
		return text( column );
}

QString BirthdayItem::getUid()
{
	return m_uid;
}
