/***************************************************************************
                          birthdayoptions.cpp  -  description
                             -------------------
    begin                : Fri Feb 22 2002
    copyright           : (C) 2002,2003 by Jan Hambrecht
    email                :  jaham@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "birthdayoptions.h"
#include <ksimpleconfig.h>

BirthdayOptions::BirthdayOptions()
{
	m_daysComing = 0;
	m_daysPassed = 0;
	m_showOnStartup = true;
	m_showAnniversary = false;
	m_daysHighlight = 0;
	m_colorHighlight = QColor( 255, 0, 0); //red
	m_showAtDaybreak = false;
}

BirthdayOptions::~BirthdayOptions()
{
}

void BirthdayOptions::load()
{
	KSimpleConfig *config = new KSimpleConfig( "kbirthdayrc", false );
	
	m_daysComing = config->readNumEntry( "daysComing", 7 );
	m_daysPassed = config->readNumEntry( "daysPassed", 0 );
	m_showOnStartup = config->readBoolEntry( "showOnStartup", true );
	m_showAnniversary = config->readBoolEntry( "showAnniversary", false );
	m_daysHighlight = config->readNumEntry( "daysHighlight", 2 );
	m_colorHighlight = config->readColorEntry( "colorHighlight", new QColor( 255, 0, 0 ) );
	m_showAtDaybreak = config->readBoolEntry( "showAtDaybreak", false );
	
	delete config;
}

void BirthdayOptions::save()
{
	KSimpleConfig *config = new KSimpleConfig( "kbirthdayrc" );
	
	config->writeEntry( "daysComing", m_daysComing );
	config->writeEntry( "daysPassed", m_daysPassed );
	config->writeEntry( "showOnStartup", m_showOnStartup );
	config->writeEntry( "showAnniversary", m_showAnniversary );
	config->writeEntry( "daysHighlight", m_daysHighlight );
	config->writeEntry( "colorHighlight", m_colorHighlight );
	config->writeEntry( "showAtDaybreak", m_showAtDaybreak );
	
	delete config;
}

uint& BirthdayOptions::DaysPassed()
{
	return m_daysPassed;
}

uint& BirthdayOptions::DaysComing()
{
	return m_daysComing;
}

bool& BirthdayOptions::ShowOnStartup()
{
	return m_showOnStartup;
}

bool& BirthdayOptions::ShowAnniversary()
{
	return m_showAnniversary;
}               

uint& BirthdayOptions::DaysHighlight()
{
	return m_daysHighlight;
}

QColor& BirthdayOptions::HighlightColor()
{
	return m_colorHighlight;
}

bool& BirthdayOptions::ShowAtDaybreak()
{
	return m_showAtDaybreak;
}
