/***************************************************************************
                          birthdayoptions.h  -  description
                             -------------------
    begin                : Fri Feb 22 2002
    copyright           : (C) 2002,2003 by Jan Hambrecht
    email                :  jaham@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BIRTHDAYOPTIONS_H
#define BIRTHDAYOPTIONS_H

#include <qcolor.h>

/**
* @brief Encapsulates all kbirthday options.
* @author Jan Hambrecht
*/

class BirthdayOptions 
{
public:
	/** @brief The standard constructor. */
	BirthdayOptions();
	
	/** @brief The destructor. */
	~BirthdayOptions();
	
	/** @brief Saves configuration options to config file. */
	void save();
	
	/** @brief Loads configuration options from config file. */
	void load();
	
	/** 
	* @brief Gets and sets notification time in days for pending events.
	* @return reference to private member
	*/
	uint& DaysComing();
	
	/** 
	* @brief Gets and sets notification time in days for passed events.
	* @return reference to private member
	*/
	uint& DaysPassed();
	
	/** 
	* @brief Gets ands sets flag for notifying events on startup.
	* @return reference to private member
	*/
	bool& ShowOnStartup();
	
	/** 
	* @brief Gets and sets flag for notifying anniversaries 
	* @return reference to private member
	*/
	bool& ShowAnniversary();
	
	/** 
	* @brief Gets and sets highlighting time in days.
	* @return reference to private member
	*/
	uint& DaysHighlight();
	
	/** 
	* @brief Gets and sets highlighting color.
	* @return reference to private member
	*/
	QColor& HighlightColor();
	
	/** 
	* @brief Gets and sets flag for notifying pending evants at daybreak.
	* @return reference to private member
	*/
	bool& ShowAtDaybreak();
	
private: // Public attributes
	
	/** @brief notification time in days */
	uint m_daysComing;
	
	/** @brief notification time in days */
	uint m_daysPassed;
	
	/** @brief highlighting time in days */
	uint m_daysHighlight;
	
	/** @brief show events on startup */
	bool m_showOnStartup;
	
	/** @brief show anniversaries */
	bool m_showAnniversary;
	
	/** @brief highlighting color */
	QColor m_colorHighlight;
	
	/** @brief show pending events at daybreak */
	bool m_showAtDaybreak;
};

#endif
