/***************************************************************************
                          confdlgimpl.cpp  -  description
                             -------------------
    begin                : Fri Oct 12 2001
    copyright           : (C) 2001-2003 by Jan Hambrecht
    email                : jaham@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "confdlgimpl.h"
#include <kcolorbtn.h>
#include <qspinbox.h>
#include <qcheckbox.h>
 
ConfDlgImpl::ConfDlgImpl( QWidget* parent, const char* name, bool modal, WFlags fl )
	:ConfDlg( parent, name, modal, fl )
{
}

ConfDlgImpl::~ConfDlgImpl()
{
}

void ConfDlgImpl::setOptions( BirthdayOptions &options )
{
	sbDaysComing->setValue( options.DaysComing() );
	sbDaysPassed->setValue( options.DaysPassed() );
	sbDaysHighlight->setValue( options.DaysHighlight() );
	cbShowOnStartup->setChecked( options.ShowOnStartup() );
	cbShowAnniversary->setChecked( options.ShowAnniversary() );
	kcbHighlight->setColor( options.HighlightColor() );
	cbShowAtDaybreak->setChecked( options.ShowAtDaybreak() );
}

void ConfDlgImpl::getOptions( BirthdayOptions &options )
{
	options.DaysComing() = sbDaysComing->value();
	options.DaysPassed() = sbDaysPassed->value();
	options.DaysHighlight() = sbDaysHighlight->value();
	options.ShowOnStartup() = cbShowOnStartup->isChecked();
	options.ShowAnniversary() = cbShowAnniversary->isChecked();
	options.HighlightColor() = kcbHighlight->color();
	options.ShowAtDaybreak() = cbShowAtDaybreak->isChecked();
}
