/*---------------------------------------------------------------------------------
Name               : KMix.c
Author             : Marvin Raaijmakers, modified by Samir L. Boulema
Description        : Plugin for keyTouch that can change the volume (using kmixer).
Date of last change: 01-Apr-2006

    Copyright (C) 2005-2006 Marvin Raaijmakers

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.


2006-03-06 Samir L. Boulema:
            Modified this plugin so that is works with kmixer (the original plugin
            worked for aumix)
-----------------------------------------------------------------------------------*/
#include <stdlib.h>
#include <unistd.h>

#include <plugin.h>


void vol_increase (KTPreferences *preferences);
void vol_decrease (KTPreferences *preferences);
void mute (KTPreferences *preferences);

KeytouchPlugin plugin_struct = {
	{"KMix", "Samir L. Boulema", "GPL 2", "1.0",
	 "For changing the volume. To use this plugin KMix needs to be installed and runnning."},
	"KMix.so",
	3,
	{{"Volume increase", KTPluginFunctionType_Function, {.function = vol_increase}},
	 {"Volume decrease", KTPluginFunctionType_Function, {.function = vol_decrease}},
	 {"Mute",            KTPluginFunctionType_Function, {.function = mute}},
	}
};


void
vol_increase (KTPreferences *preferences)
{
	if (fork() == 0)
	{
		execlp ("sh", "sh", "-c", "dcop kmix Mixer0 increaseVolume 1+", NULL);
	}
}

void
vol_decrease (KTPreferences *preferences)
{
	if (fork() == 0)
	{
		execlp ("sh", "sh", "-c", "dcop kmix Mixer0 decreaseVolume 1-", NULL);
	}
}

void
mute (KTPreferences *preferences)
{
	if (fork() == 0)
	{
		execlp ("sh", "sh", "-c", "dcop kmix Mixer0 toggleMute 0", NULL);
	}
}
