/* ============================================================
 * Author: M. Asselstine <asselsm@gmail.com>
 * Date  : 05-08-2005
 * Description : 
 * 
 * Copyright 2005 by M. Asselstine

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */
#ifndef UPLOADPROGRESS_H
#define UPLOADPROGRESS_H

#include <uploadprogressui.h>

#include <kio/job.h>

class KIO::Job;

/**
 * Implements a simple upload dialog that will be used to provide
 * the user with some indication as to what is happening during
 * an upload.
 * @short Upload progress information dialog
 * @author M. Asselstine <asselsm@gmail.com>
 */
class UploadProgress : public UploadProgressUI
{
    Q_OBJECT

public:
    /** Constructor.
     *  @param parent Pointer to parent widget
     */
    UploadProgress(QWidget* parent, const char* name = 0);

    /** Destructor. */
    ~UploadProgress();

    /** Set the pixmap to display
     *  @param pixmap Reference to the new pixmap to display
     */
    void setPixmap(const QPixmap& pixmap);

    /** Set the number of photos being uploaded. Used to
     *  calibrate the overall progress bar.
     *  @param total The number of photos being uploaded
     */
    void setNumPhotos(int total);

    /** Set the number of completed photos. Used to update
     *  the overall progress bar.
     *  @param num Number of completed photos
     */
    void setNumCompleted(int num);

    /** Advance the overall progress bar
     *  @param amount Amount to advance
     */
    void advance(int amount);

protected:
    /** Default constructor, not to be used */
    UploadProgress() {};

signals:
    /** Signaled when the user presses the cancel button */
    void cancelClicked();

private:
    /** Needed to track progress since the doco says you can have
     *  -ve progress yet if set to  -ve progress() returns 0??
     *  @todo maybe check in QT4 if this is fixed and remove this workaround.
     */
    int m_overall;
};

#endif
