/**
 * @file
 * Custom event implementation.
 *
 * Kisa provides spell checking as you type and displays the result in a small
 * window on your Desktop.
 *
 * Copyright (c) 2007 by Pete Black <theblackpeter@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * @author Pete Black <theblackpeter@gmail.com>
 */

#include "kisaevent.h"


KisaEvent::KisaEvent() : QEvent(QEvent::None) {
  m_type = QEvent::None;
  m_window = 77;
  m_key = '\0';
  m_state  = -1;
  m_xEvent = NULL;
}


KisaEvent::KisaEvent(const QEvent::Type& t, const Window& window,
                     XEvent* xEvent) : QEvent(t) {
  m_type = t;
  m_window = window;
  m_key = '\0';
  m_state  = -1;
  m_xEvent = xEvent;
}


KisaEvent::KisaEvent(const QEvent::Type&t, const Window& window,
                     const QChar& key, XEvent* xEvent) : QEvent(t) {
  m_type = t;
  m_window = window;
  m_key = key;
  m_state  = -1;
  m_xEvent = xEvent;
}


KisaEvent::KisaEvent(const QEvent::Type&t, const Window& window,
                     const int& state, XEvent* xEvent) : QEvent(t) {
  m_type = t;
  m_window = window;
  m_key = '\0';
  m_state  = state;
  m_xEvent = xEvent;
}


KisaEvent::~KisaEvent() {
}


bool KisaEvent::isNone() {
  if(m_type == None)
    return true;

  return false;
}
