/**
 * @file
 * X11 and Qt name clash resolver.
 *
 * Kisa provides spell checking as you type and displays the result in a small
 * window on your Desktop.
 *
 * These macros and types override and resolve the conflict between some X11 and
 * Qt defines. For instance, the "type" field in X::XEvent (defined in X.h) and
 * QEvent::Type. The original X11 symbols are still accessible, but under
 * different names.
 *
 * @warning Don't put something similar to this:
 *    @code
 *      #ifndef X11FIX_H
 *      #define X11FIX_H
 *    @endcode
 * in the beginning, as this file may need to be included multiple times.
 *
 * Copyright (c) 2007 by Pete Black <theblackpeter@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * @author Pete Black <theblackpeter@gmail.com>
 */

/**
 * The original X11 event types. Redefined to avoid name clashes.
 */
enum {
  XNone = None,             /**< the original X11 None event type */
  XFocusIn = FocusIn,       /**< the original X11 FocusIn event type */
  XFocusOut = FocusOut,     /**< the original X11 FocusOut event type */
  XKeyPress = KeyPress,     /**< the original X11 KeyPress event type */
  XKeyRelease = KeyRelease, /**< the original X11 KeyRelease event type */
};

// remove the X11 types
#undef None
#undef FocusIn
#undef FocusOut
#undef KeyPress
#undef KeyRelease


/**
 * X11 integer error indication, common function return. Defined in X11/Xlib.h
 */
typedef Status XStatus;


/**
 * The X11 event mask type. Event masks that are of intrest to us are:
 *  @li NoEventMask
 *  @li KeyPressMask
 *  @li SubstructureNotifyMask
 *  @li VisibilityChangeMask
 */
typedef unsigned long EventMask;


/**
 * The X11 event type. Event types that are of intrest to us are:
 *  @li KeyPress, for whenever a key is pressed in any window
 *  @li VisibilityNotify, for whenever our @em own application becomes
 *      obstructed or unobstructed
 *  @li CreateNotify, for whenever a new window is created
 *  @li MapNotify, for whenever a window is made visible
 */
typedef unsigned int EventType;
