TEMPLATE = app

VERSION = 0.43

SOURCES += kisa.cpp \
           main.cpp \
           kisawidget.cpp \
           kisathread.cpp \
           kisasettings.cpp

HEADERS += kisa.h \
           kisawidget.h \
           kisathread.h \
           kisasettings.h

CONFIG += warn_on \
          thread \
          qt \
          debug_and_release

TARGET = kisa

LIBS += -laspell \
        ../bin/libkisa.a

TARGETDEPS += ../bin/libkisa.a

FORMS += kisawidget.ui \
         kisasettings.ui

DESTDIR = ../bin

QT += gui

QMAKE_CXXFLAGS_DEBUG += -fno-inline

QMAKE_CXXFLAGS_RELEASE += -DQT_NO_DEBUG_OUTPUT

RESOURCES += kisa.qrc

target.path = /usr/bin

doc.path = /usr/share/doc/kisa-$$VERSION
doc.files += ../README
doc.files += ../COPYING
doc.files += ../ChangeLog

icon.path = /usr/share/pixmaps
icon.files += ./icons/kisa.png

desktop.path = /usr/share/applications
desktop.files += ../kisa.desktop

# actually the path should be "/usr/share/kisa/translations/" but as there are
# no other files going to "/usr/share/kisa/" that directory doesn't get delete
# one could write a custom makefile target rule...
translations.path = /usr/share/kisa
for(lang, LINGUAS){
  exists(../translations/kisa_$${lang}.qm){
    translations.files += ../translations/kisa_$${lang}.qm
  }
}

INSTALLS += target \
            desktop \
            doc \
            icon \
            translations

isEmpty(translations.files) {
  INSTALLS -= translations
}

TRANSLATIONS += kisa_sv.ts

INCLUDEPATH += lib

MAKEFILE = makefile
