/*******************************************************************************
**                        systemtraywidget.h
**                             part of
**                konserve -- A small backup application
**			 -------------------
**  copyright: (C) 2002 - 2004 by Florian Simnacher
**  email    : simnacher AT gmx DOT de
*******************************************************************************/

/*******************************************************************************
**  This program is free software; you can redistribute it and/or             **
**  modify it under the terms of the GNU General Public License               **
**  as published by the Free Software Foundation; either version 2            **
**  of the License, or (at your option) any later version.                    **
**                                                                            **
**  This program is distributed in the hope that it will be useful,           **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of            **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             **
**  GNU General Public License for more details.                              **
**                                                                            **
**  You should have received a copy of the GNU General Public License         **
**  along with this program; if not, write to the Free Software               **
**  Foundation, Inc., 59 Temple Place - Suite 330, Boston,                    **
**  MA  02111-1307, USA.                                                      **
*******************************************************************************/
#ifndef SYSTEMTRAYWIDGET_H
#define SYSTEMTRAYWIDGET_H

// Qt includes
#include <qwidget.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qstringlist.h>

// KDE includes
#include <kpopupmenu.h>
#include <kiconloader.h>

// My includes
#include "profilemngrinterface.h"

////////////////////////////////////////////////////////////////////////////////
//////////                  class SystemTrayWidget                       ///////
////////////////////////////////////////////////////////////////////////////////

class SystemTrayWidget : public QWidget,
                         public ProfileMngrInterface
{
    Q_OBJECT

public:
    SystemTrayWidget( QWidget *parent, const char* name );
    ~SystemTrayWidget();

    void inserted( BackupProfile *b );
    void changed( BackupProfile * );
    void removed( QString s );

    void paintEvent( QPaintEvent *ev );
    void mousePressEvent( QMouseEvent *ev );
    void dragEnterEvent(QDragEnterEvent* event);
    void dropEvent(QDropEvent* event);

signals:
    void wizard( QString source );
    void wizard();
    void preferences();
    void help();
    void quit();
    void doBackup( QString identifier );

private slots:
    void slotPreferences();
    void slotHelp();
    void slotQuit();
    void slotDoBackup( int id );
    void slotWizard();

private:
    // Identifiers of the PopupMenu entries
    static const int WIZARD_ID      = 5;
    static const int DUMP_ALL_ID    = 4;
    static const int QUIT_ID        = 3;
    static const int HELP_ID        = 2;
    static const int PREF_ID        = 1;
    static const int HIGHEST_STD_ID = WIZARD_ID;

private:
    QPixmap      mPixmap;
    KPopupMenu  *mpPopupMenu;
    QStringList  mProfileNameList;
    int          mHighestMenuId;
    KIconLoader *mpIconLoader;
};

#endif
