/***************************************************************************
 *   Copyright (C) 2008 by David Santo Orcero                              *
 *   irbis@orcero.org                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KRADVIEWVIEW_H_
#define _KRADVIEWVIEW_H_

#include <qwidget.h>
#include <kparts/part.h>
#include <kradviewiface.h>

#include "panel2d.h"

class QPainter;
class KURL;

/**
 * This is the main view class for kradview.  Most of the non-menu,
 * non-toolbar, and non-statusbar (e.g., non frame) GUI code should go
 * here.
 *
 * This kradview uses an HTML component as an example.
 *
 * @short Main view
 * @author David Santo Orcero <irbis@orcero.org>
 * @version 0.1
 */
class kradviewView:public QWidget, public kradviewIface
{
Q_OBJECT public:
    /**
     * Default constructor
     */
    kradviewView (QWidget * parent);

    /**
     * Destructor
     */
    virtual ~ kradviewView ();

    /**
     * Random 'get' function
     */
  QString currentURL ();

    /**
     * Random 'set' function accessed by DCOP
     */
  virtual void openURL (QString url);

    /**
     * Random 'set' function
     */
  virtual void openURL (const KURL & url);

    /**
     * Print this view to any medium -- paper or not
     */
  void print (QPainter *, int height, int width);


    /**
     * Opens the given pixmap
    virtual void openPixmap(const QPixmap& pixmap);
     */

    /**
     * Save to URL
     */
  virtual void saveURL (const KURL & url);


    /**
    * This variable keeps the reference of the main view screen on 2D
    */

public:
    class Panel2D * m_Panel2D;




    signals:
    /**
     * Use this signal to change the content of the statusbar
     */
  void signalChangeStatusbar (const QString & text);

    /**
     * Use this signal to change the content of the caption
     */
  void signalChangeCaption (const QString & text);

  private slots:void slotOnURL (const QString & url);
  void slotSetTitle (const QString & title);

private:
    KParts::ReadOnlyPart * m_html;
};

#endif // _KRADVIEWVIEW_H_
