/*  KRunning - Certification.cpp
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mit Sep 18 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "Certification.h"


Certification::Certification (QWidget * parent, const char *name) : CertificationGUI(parent,name,true) {
    CertificationView-> setRootIsDecorated ( false);
    CertificationView->addColumn    ( i18n( "Printed" ));
    CertificationView->setColumnAlignment ( 0, Qt::AlignCenter );
    CertificationView->addColumn    ( i18n( "Number" ));
    CertificationView->setColumnAlignment ( 1, Qt::AlignRight);
    CertificationView->addColumn    ( i18n( "Name" ));
    CertificationView->addColumn    ( i18n( "Forename" ));
    CertificationView->addColumn    ( i18n( "Team" ));
    CertificationView->addColumn    ( i18n( "Birthday" ));
    CertificationView->setColumnAlignment ( 5, Qt::AlignHCenter );
    CertificationView->addColumn    ( i18n( "Class" ));

    CertificationView->addColumn    ( i18n( "Time" ));
    if (prefs->getPrintRunnerSpeed()){
        CertificationView->addColumn    ( i18n( "Speed"));
    }
    //Qt::AlignHCenter
    CertificationView->addColumn    ( i18n( "Total" ));
    CertificationView->setColumnAlignment ( 8, Qt::AlignRight );
    CertificationView->addColumn    ( i18n( "Class" ));
    CertificationView->setColumnAlignment ( 9, Qt::AlignRight );


    CertificationView->setShowSortIndicator(true);
    CertificationView->setAllColumnsShowFocus ( true );
    CertificationView->setMultiSelection ( true );

    certPopupMenu = new KPopupMenu(CertificationView,"popupMenu");
    certPopupMenu->setCaption("Select Menu");
    certPopupMenu->insertTitle(i18n("Select Menu"));
    certPopupMenu->insertItem( i18n("All"), this, SLOT(selectAllItems()) );
    certPopupMenu->insertItem( i18n("Nothing"), this, SLOT(selectNoItems()));
    certPopupMenu->insertSeparator();
    certPopupMenu->insertItem( i18n("First from each Class"), this, SLOT(selectFirst()) );
    certPopupMenu->insertItem( i18n("First 3 from each Class"), this, SLOT(selectFirstThree() ) );
    certPopupMenu->insertSeparator();
    certPopupMenu->insertItem( i18n("All without the first"), this, SLOT(selectNFirst()) );
    certPopupMenu->insertItem( i18n("All without he first three"), this, SLOT(selectNFirstThree() ) );

    connect (CertificationView,SIGNAL(rightButtonPressed ( QListViewItem *, const QPoint & ,int ) ),this,SLOT(slotShowPopupMenu(QListViewItem*,const QPoint &,int)));
}

Certification::~Certification() {

}

void Certification::setDefaultSettings() {
    CertificationView->clear();
    CertificationListItem *item;
    DBConnection::TimeList timelist;
    DBConnection::RunnerList runnerlist;
    DBConnection::RunnerTimeList runnertimelist;

    runnerlist=g_pMainUseCase->getConnection()->getRunnerListByEvent(g_pMainUseCase->getCurrentEvent()->getNumber(),true);
    runnertimelist=g_pMainUseCase->getConnection()->getRunnerTimeListByEvent(g_pMainUseCase->getCurrentEvent()->getNumber());
    timelist=g_pMainUseCase->getConnection()->getTimeListByEvent(g_pMainUseCase->getCurrentEvent()->getNumber());
    DBConnection::RunnerList::iterator it;
    DBConnection::TimeList::iterator ittl;
    DBConnection::RunnerTimeList::iterator itrtl;

    for ( it = runnerlist.begin(); it != runnerlist.end(); ++it ) {

        if ((*it).getState() == KRunningRunnerObject::eEvaluated) {
            for (itrtl=runnertimelist.begin();itrtl!=runnertimelist.end();++itrtl) {
                if ((*itrtl).getRunnerRef()==(*it).getNumber()) {
                    for (ittl=timelist.begin();ittl!=timelist.end();++ittl) {
                        if ((*ittl).getNumber()==(*itrtl).getTimeRef()) {
                            item=new CertificationListItem(CertificationView,&(*it),&(*ittl));
                            CertificationView->insertItem(item);
                        }
                    }
                }
            }
        }
    }
}

void Certification::slotShowPopupMenu(QListViewItem* item,const QPoint & point,int col) {
    certPopupMenu->exec(point);
}


void Certification::selectAllItems() {
    for( int i = 0 ; i < CertificationView->childCount() ; i++ ) {
        CertificationView->setSelected( CertificationView->itemAtIndex(i),true);
    }
}
void Certification::selectNoItems() {
    for( int i = 0 ; i < CertificationView->childCount() ; i++ ) {
        CertificationView->setSelected( CertificationView->itemAtIndex(i),false);
    }
}

void Certification::selectFirstThree() {
    for( int i = 0 ; i < CertificationView->childCount() ; i++ ) {
        if (CertificationView->itemAtIndex(i)->text(9).toInt() <=3) {
            CertificationView->setSelected( CertificationView->itemAtIndex(i),true);
        } else {
            CertificationView->setSelected( CertificationView->itemAtIndex(i),false);
        }

    }
}

void Certification::selectNFirstThree() {
    for( int i = 0 ; i < CertificationView->childCount() ; i++ ) {
        if (CertificationView->itemAtIndex(i)->text(9).toInt() >= 4) {
            CertificationView->setSelected( CertificationView->itemAtIndex(i),true);
        } else {
            CertificationView->setSelected( CertificationView->itemAtIndex(i),false);
        }

    }
}

void Certification::selectFirst() {
    for( int i = 0 ; i < CertificationView->childCount() ; i++ ) {
        if (CertificationView->itemAtIndex(i)->text(9).toInt() == 1) {
            CertificationView->setSelected( CertificationView->itemAtIndex(i),true);
        } else {
            CertificationView->setSelected( CertificationView->itemAtIndex(i),false);
        }

    }
}

void Certification::selectNFirst() {
    for( int i = 0 ; i < CertificationView->childCount() ; i++ ) {
        if (CertificationView->itemAtIndex(i)->text(9).toInt() != 1) {
            CertificationView->setSelected( CertificationView->itemAtIndex(i),true);
        } else {
            CertificationView->setSelected( CertificationView->itemAtIndex(i),false);
        }

    }
}



/** Funktion to print Certifications
  @version 0.1
  @param a KPrinter Object
*/
void Certification::print(KPrinter * printer) {
    Printing *printing = new Printing(printer);
    printing->printCertificationList(CertificationView);
    delete (printing);
}

int CertificationListItem::compare( QListViewItem * i, int col, bool ascending ) const
{
    CertificationListItem *other = (CertificationListItem *)i;
    switch ( col ) {
    case 1:
    case 8:
    case 9:
        if ( text(col).toInt() == other->text(col).toInt() )
            return 0;
        else
            return text(col).toInt() < other->text(col).toInt() ? -1 : 1;
        break;
    default:
        // use default method for colum 0 and others added in the future
        return QListViewItem::compare( i, col, ascending );
    };
}

CertificationListItem::CertificationListItem( KListView *parent,KRunningRunnerObject *ro,KRunningTimeObject * to)
        : KListViewItem( parent )
{
    runnerobj = ro;
    setText(1, QString::number(runnerobj->getNumber()) );

    setText(2, runnerobj->getSurname() );
    setText(3, runnerobj->getForename() );
    setText(4, runnerobj->getTeamname());
    setText(5, QString::number(runnerobj->getBirthday()) );
    setText(6, Evaluation::getClassString(runnerobj->getBirthday(),runnerobj->getSex()));
    if (to->getNumber() > 0) {
        setText(7,to->getTimeString("hh:mm:ss.zzz"));
    }
    if (runnerobj->getState()==KRunningRunnerObject::eEvaluated) {
        setText(8,QString::number(runnerobj->getTotalPlace()));
        setText(9,QString::number(runnerobj->getClassPlace()));
        /*setText(9,QString::number(runnerobj->getSexPlace()));
        setText(10,QString::number(runnerobj->getTeamPlace()));
        setText(11,QString::number(runnerobj->getNationPlace()));
        setText(12,i18n("Evaluated"));*/
    }

}

void CertificationListItem::paintCell ( QPainter * painter, const QColorGroup & cg, int column, int width, int align )
{
    /*  QColorGroup _cg = cg;
      if ( !painter )
          return;
      if (align==Qt::AlignRight) {
          width-=10;


          const QPixmap *pm = listView()->viewport()->backgroundPixmap();
          if (pm && !pm->isNull())
          {
              _cg.setBrush(QColorGroup::Base, QBrush(backgroundColor(), *pm));
              painter->setBrushOrigin( -listView()->contentsX(), -listView()->contentsY() );
          }
          else if (isAlternate())
              _cg.setColor(QColorGroup::Base, static_cast< KListView* >(listView())->alternateBackground());

      }

      */
    KListViewItem::paintCell(painter, cg, column, width, align);
}



