/*  KRunning - Certification.h
 *  Copyright (C) 2002 by Andreas Scherf
 *  Begin Mit Sep 18 2002 write to scherfa@web.de if you found a bug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef KRUNNING_CERTIFICATION_H
#define KRUNNING_CERTIFICATION_H

// KDE Stuff
#include <klistview.h>
#include <klocale.h>
#include <kpopupmenu.h>

#include "CertificationGUI.h"
#include "DBConnection.h"
#include "Evaluation.h"
#include "Printing.h"

class Certification : public CertificationGUI
{
        Q_OBJECT

        enum ECertificationColumn {
            e1,e2
    };//;TODO Name eintragen und Printing sowie die Liste auf den Aktuellen STand bringen
    public:
        Certification (QWidget * parent = 0, const char *name = 0);
        virtual ~ Certification ();
        void setDefaultSettings();
        void print(KPrinter * printer);
    public slots: // Public slots
        void selectAllItems();
        void selectNoItems();
        void selectFirstThree();
        void selectFirst();
        void selectNFirstThree();
        void selectNFirst();
    protected:
    protected slots:
        void slotShowPopupMenu(QListViewItem* item,const QPoint & point,int col);
    private:
        KPopupMenu  * certPopupMenu;
};

class CertificationListItem : public KListViewItem
{
    public:
        CertificationListItem( KListView *parent,KRunningRunnerObject *ro,KRunningTimeObject * to);

        KRunningRunnerObject *runner() { return runnerobj; }
        int compare( QListViewItem * i, int col, bool ascending ) const;
        void paintCell ( QPainter * painter, const QColorGroup & cg, int column, int width, int align );
    protected:
        KRunningRunnerObject *runnerobj;
};


#endif // CERTIFICATION_H
